/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.aws;

import java.util.ArrayList;
import java.util.List;
import net.utoolity.atlassian.dry.AWSStaticSessionCredentialsProvider;
import net.utoolity.atlassian.dry.ParameterValidationException;
import net.utoolity.atlassian.ifaws.api.ECRCredentialsDTO;
import org.apache.commons.lang3.StringUtils;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ecr.EcrClient;
import software.amazon.awssdk.services.ecr.EcrClientBuilder;
import software.amazon.awssdk.services.ecr.model.AuthorizationData;
import software.amazon.awssdk.services.ecr.model.GetAuthorizationTokenRequest;
import software.amazon.awssdk.services.ecr.model.GetAuthorizationTokenResponse;

public final class ECR {
    private static final String REGISTRY_ID_PATTERN = "[0-9]{12}";

    private ECR() {
    }

    public static boolean isValidECRRegistryId(String registryId) {
        return null != registryId && registryId.matches(REGISTRY_ID_PATTERN);
    }

    public static List<ECRCredentialsDTO> getECRCredentials(AwsSessionCredentials awsSessionCredentials, List<String> registryIds, String regionName) {
        return ECR.getECRCredentials(awsSessionCredentials, registryIds, regionName, null);
    }

    public static List<ECRCredentialsDTO> getECRCredentials(AwsSessionCredentials awsSessionCredentials, List<String> registryIds, String regionName, ClientOverrideConfiguration clientConfiguration) {
        return ECR.getECRCredentials(new AWSStaticSessionCredentialsProvider(awsSessionCredentials), registryIds, regionName, clientConfiguration);
    }

    public static List<ECRCredentialsDTO> getECRCredentials(AwsCredentialsProvider awsCredentialsProvider, List<String> registryIds, String regionName, ClientOverrideConfiguration clientConfiguration) {
        ArrayList<ECRCredentialsDTO> ecrCredentialsDTOList = new ArrayList<ECRCredentialsDTO>();
        EcrClientBuilder ecrClientBuilder = (EcrClientBuilder)EcrClient.builder().credentialsProvider(awsCredentialsProvider);
        if (null != clientConfiguration) {
            ecrClientBuilder.overrideConfiguration(clientConfiguration);
        }
        if (StringUtils.isNotBlank((CharSequence)regionName)) {
            Region region = Region.of((String)regionName);
            if (null != region) {
                ecrClientBuilder.region(region);
            } else {
                throw new ParameterValidationException("Unknown region name: " + regionName);
            }
        }
        EcrClient ecrClient = (EcrClient)ecrClientBuilder.build();
        GetAuthorizationTokenRequest.Builder getAuthorizationTokenRequestBuilder = GetAuthorizationTokenRequest.builder();
        if (registryIds.size() > 0) {
            getAuthorizationTokenRequestBuilder.registryIds(registryIds);
        }
        GetAuthorizationTokenResponse getAuthorizationTokenResult = ecrClient.getAuthorizationToken((GetAuthorizationTokenRequest)getAuthorizationTokenRequestBuilder.build());
        List authorizationDataList = getAuthorizationTokenResult.authorizationData();
        for (AuthorizationData authorizationData : authorizationDataList) {
            ECRCredentialsDTO ecrCredentialsDTO = new ECRCredentialsDTO(authorizationData);
            ecrCredentialsDTOList.add(ecrCredentialsDTO);
        }
        return ecrCredentialsDTOList;
    }
}

