/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.aws;

import net.utoolity.atlassian.ifaws.api.CodeArtifactCredentialsDTO;
import org.apache.commons.lang3.StringUtils;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codeartifact.CodeartifactClient;
import software.amazon.awssdk.services.codeartifact.CodeartifactClientBuilder;
import software.amazon.awssdk.services.codeartifact.model.GetAuthorizationTokenRequest;
import software.amazon.awssdk.services.codeartifact.model.GetAuthorizationTokenResponse;

public final class CodeArtifact {
    private static final String DOMAIN_PATTERN = "[a-z][a-z0-9\\-]{0,48}[a-z0-9]";
    private static final String DOMAIN_OWNER_PATTERN = "[0-9]{12}";
    private static final int DURATION_SECONDS_MIN = 900;
    private static final int DURATION_SECONDS_MAX = 43200;

    private CodeArtifact() {
    }

    public static CodeArtifactCredentialsDTO getCodeArtifactCredentials(AwsCredentialsProvider awsCredentials, String domain, String domainOwner, Integer durationSeconds, String regionName, ClientOverrideConfiguration clientConfiguration) {
        CodeartifactClientBuilder codeArtifactClientBuilder = (CodeartifactClientBuilder)CodeartifactClient.builder().credentialsProvider(awsCredentials);
        if (null != clientConfiguration) {
            ((CodeartifactClientBuilder)codeArtifactClientBuilder.httpClientBuilder((SdkHttpClient.Builder)ApacheHttpClient.builder())).overrideConfiguration(clientConfiguration);
        }
        if (null != regionName) {
            codeArtifactClientBuilder.region(Region.of((String)regionName));
        }
        CodeartifactClient codeArtifact = (CodeartifactClient)codeArtifactClientBuilder.build();
        GetAuthorizationTokenRequest.Builder getAuthorizationTokenRequestBuilder = GetAuthorizationTokenRequest.builder().domain(domain);
        if (StringUtils.isNotBlank((CharSequence)domainOwner)) {
            getAuthorizationTokenRequestBuilder.domainOwner(domainOwner);
        }
        if (null != durationSeconds) {
            getAuthorizationTokenRequestBuilder.durationSeconds(Long.valueOf(durationSeconds.longValue()));
        }
        GetAuthorizationTokenResponse getAuthorizationTokenResult = codeArtifact.getAuthorizationToken((GetAuthorizationTokenRequest)getAuthorizationTokenRequestBuilder.build());
        CodeArtifactCredentialsDTO codeArtifactCredentialsDTO = new CodeArtifactCredentialsDTO(getAuthorizationTokenResult);
        return codeArtifactCredentialsDTO;
    }

    public static boolean isValidDomain(String domain) {
        return null != domain && domain.matches(DOMAIN_PATTERN);
    }

    public static boolean isValidDomainOwner(String domainOwner) {
        return null != domainOwner && domainOwner.matches(DOMAIN_OWNER_PATTERN);
    }

    public static boolean isValidDurationSeconds(int durationSeconds) {
        if (0 == durationSeconds) {
            return true;
        }
        return durationSeconds >= 900 && durationSeconds <= 43200;
    }
}

