/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.aws;

import com.atlassian.plugin.util.ClassLoaderUtils;
import com.google.common.collect.ImmutableMap;
import java.net.URL;
import java.util.Map;
import net.utoolity.atlassian.dry.PluginInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AWSIcons {
    private static final Map<String, String> SERVICE_ICON_NAME_DEVIATIONS = new ImmutableMap.Builder().put((Object)"accessanalyzer", (Object)"identityandaccessmanagement").put((Object)"acm", (Object)"certificatemanager").put((Object)"acm-pca", (Object)"certificatemanager").put((Object)"aiq", (Object)"iq").put((Object)"amp", (Object)"managedserviceforprometheus").put((Object)"amazonlocationservice", (Object)"locationservice").put((Object)"amplifybackend", (Object)"amplify").put((Object)"apigatewaymanagementapi", (Object)"apigateway").put((Object)"apigatewayv2", (Object)"apigateway").put((Object)"appintegrations", (Object)"appflow").put((Object)"application-autoscaling", (Object)"applicationautoscaling").put((Object)"application-insights", (Object)"cloudwatch").put((Object)"augmentedairuntime", (Object)"augmentedaia2i").put((Object)"cloudhsmv2", (Object)"cloudhsm").put((Object)"cloudsearch", (Object)"cloudsearch").put((Object)"codeguruprofiler", (Object)"codeguru").put((Object)"codeguru-reviewer", (Object)"codeguru").put((Object)"codestar-connections", (Object)"codestar").put((Object)"codestar-notifications", (Object)"codestar").put((Object)"cognito-identity", (Object)"cognito").put((Object)"cognito-idp", (Object)"cognito").put((Object)"cognito-sync", (Object)"cognito").put((Object)"comprehendmedical", (Object)"comprehend").put((Object)"compute-optimizer", (Object)"computeoptimizer").put((Object)"connect-contact-lens", (Object)"connect").put((Object)"connectparticipant", (Object)"connect").put((Object)"cur", (Object)"costandusagereport").put((Object)"customer-profiles", (Object)"connect").put((Object)"databrew", (Object)"gluedatabrew").put((Object)"dax", (Object)"dynamodb").put((Object)"deeplens", (Object)"deeplense").put((Object)"discovery", (Object)"applicationdiscoveryservice").put((Object)"dms", (Object)"databasemigrationservice").put((Object)"docdb", (Object)"documentdb").put((Object)"devops-guru", (Object)"devopsguru").put((Object)"ds", (Object)"directoryservice").put((Object)"dynamodbstreams", (Object)"dynamodb").put((Object)"ebs", (Object)"elasticblockstore").put((Object)"ecr-public", (Object)"elasticcontainerregistry").put((Object)"ecr", (Object)"elasticcontainerregistry").put((Object)"ecs", (Object)"elasticcontainerservice").put((Object)"efs", (Object)"elasticfilesystem").put((Object)"eks", (Object)"elasticcontainerkubernetes").put((Object)"elastic-inference", (Object)"elasticinference").put((Object)"elb", (Object)"elasticloadbalancing").put((Object)"emr-containers", (Object)"emr").put((Object)"es", (Object)"elasticsearchservice").put((Object)"events", (Object)"eventbridge").put((Object)"expressworkflow", (Object)"stepfunctions").put((Object)"finspace-data", (Object)"finspace").put((Object)"firehose", (Object)"kinesisfirehose").put((Object)"fms", (Object)"firewallmanager").put((Object)"forecastquery", (Object)"forecast").put((Object)"freertosota", (Object)"freertos").put((Object)"fsx-lustre", (Object)"fsxforlustre").put((Object)"fsx-windows", (Object)"fsxforwindowsfileserver").put((Object)"glacier", (Object)"simplestorageserviceglacier").put((Object)"greengrass", (Object)"iotgreengrass").put((Object)"health", (Object)"personalhealthdashboard").put((Object)"iam", (Object)"identityandaccessmanagement").put((Object)"identitystore", (Object)"singlesignon").put((Object)"imagebuilder", (Object)"ec2imagebuilder").put((Object)"iot-data", (Object)"iotanalytics").put((Object)"iot", (Object)"iotcore").put((Object)"iot1click-devices", (Object)"iot1click").put((Object)"iot1click-projects", (Object)"iot1click").put((Object)"iotdeviceadvisor", (Object)"iotdevicemanagement").put((Object)"iotfleethub", (Object)"iotdevicemanagement").put((Object)"iotevents-data", (Object)"iotevents").put((Object)"iotwireless", (Object)"iotcore").put((Object)"ivs", (Object)"interactivevideoservice").put((Object)"kafka", (Object)"managedstreamingforkafka").put((Object)"kinesis", (Object)"kinesisdatastreams").put((Object)"kinesisanalytics", (Object)"kinesisdataanalytics").put((Object)"kinesisvideo", (Object)"kinesisvideostreams").put((Object)"kms", (Object)"keymanagementservice").put((Object)"lex-models", (Object)"lex").put((Object)"lex-runtime", (Object)"lex").put((Object)"lexv2-models", (Object)"lex").put((Object)"license-manager", (Object)"licensemanager").put((Object)"logs", (Object)"cloudwatch").put((Object)"lookoutequipment", (Object)"lookoutforequipment").put((Object)"lookoutmetrics", (Object)"lookoutformetrics").put((Object)"lookoutvision", (Object)"lookoutforvision").put((Object)"marketplace", (Object)"marketplacelight").put((Object)"marketplacecommerceanalytics", (Object)"marketplacelight").put((Object)"marketplace-entitlement", (Object)"marketplacelight").put((Object)"mcs", (Object)"keyspaces").put((Object)"mediaconnect", (Object)"elementalmediaconnect").put((Object)"mediaconvert", (Object)"elementalmediaconvert").put((Object)"medialive", (Object)"elementalmedialive").put((Object)"mediapackage", (Object)"elementalmediapackage").put((Object)"mediapackage-vod", (Object)"elementalmediapackage").put((Object)"mediastore", (Object)"elementalmediastore").put((Object)"mediastore-data", (Object)"elementalmediastore").put((Object)"mediatailor", (Object)"elementalmediatailor").put((Object)"meteringmarketplace", (Object)"marketplacelight").put((Object)"mgh", (Object)"migrationhub").put((Object)"mgn", (Object)"managedserviceforgrafana").put((Object)"mobile", (Object)"consolemobileapplication").put((Object)"mwaa", (Object)"managedworkflowsforapacheairflow").put((Object)"networkmanager", (Object)"transitgateway").put((Object)"network-firewall", (Object)"networkfirewall").put((Object)"nimble", (Object)"nimblestudio").put((Object)"opsworkschefautomate", (Object)"opsworks").put((Object)"opsworkscm", (Object)"opsworks").put((Object)"opsworkspuppetenterprise", (Object)"opsworks").put((Object)"phd", (Object)"personalhealthdashboard").put((Object)"pi", (Object)"rds").put((Object)"pinpoint-email", (Object)"pinpoint").put((Object)"pinpoint-sms-voice", (Object)"pinpoint").put((Object)"pricing", (Object)"costandusagereport").put((Object)"qldb", (Object)"quantumledgerdatabase").put((Object)"qldb-session", (Object)"quantumledgerdatabase").put((Object)"ram", (Object)"resourceaccessmanager").put((Object)"rds-data", (Object)"rds").put((Object)"rdsvmware", (Object)"rdsonvmware").put((Object)"redshift-data", (Object)"redshift").put((Object)"resource-groups", (Object)"systemsmanager").put((Object)"resourcegroupstaggingapi", (Object)"systemsmanager").put((Object)"route53domains", (Object)"route53").put((Object)"route53resolver", (Object)"route53").put((Object)"s3outposts", (Object)"s3onoutpostsstorage").put((Object)"s3", (Object)"simplestorageservice").put((Object)"s3control", (Object)"simplestorageservice").put((Object)"sagemaker-featurestore-runtime", (Object)"sagemaker").put((Object)"sagemaker-runtime", (Object)"sagemaker").put((Object)"schemas", (Object)"eventbridge").put((Object)"serverlessrepo", (Object)"serverlessapplicationrepository").put((Object)"servicediscovery", (Object)"cloudmap").put((Object)"servicecatalog-appregistry", (Object)"servicecatalog").put((Object)"ses", (Object)"simpleemailservice").put((Object)"signer", (Object)"identityandaccessmanagement").put((Object)"sms-voice", (Object)"pinpoint").put((Object)"sms", (Object)"pinpoint").put((Object)"sns", (Object)"simplenotificationservice").put((Object)"sqs", (Object)"simplequeueservice").put((Object)"ssm-contacts", (Object)"systemsmanager").put((Object)"ssm-incidents", (Object)"systemsmanagerincidentmanager").put((Object)"ssm", (Object)"systemsmanager").put((Object)"sso", (Object)"singlesignon").put((Object)"sso-oidc", (Object)"singlesignon").put((Object)"sts", (Object)"identityandaccessmanagement").put((Object)"synthetics", (Object)"cloudwatch").put((Object)"transcribemedical", (Object)"transcribe").put((Object)"transfer", (Object)"transferfamily").put((Object)"vpc", (Object)"virtualprivatecloud").put((Object)"vpn", (Object)"clientvpn").put((Object)"waf-regional", (Object)"waf").put((Object)"wam", (Object)"workspaces").put((Object)"workmailmessageflow", (Object)"workmail").put((Object)"dlm", (Object)"general").put((Object)"fis", (Object)"general").put((Object)"importexport", (Object)"general").put((Object)"machinelearning", (Object)"general").put((Object)"mturk", (Object)"general").put((Object)"sdb", (Object)"general").put((Object)"service-quotas", (Object)"managementconsole").put((Object)"swf", (Object)"expressworkflow").put((Object)"states", (Object)"stepfunctions").build();
    private static final Logger log = LoggerFactory.getLogger(AWSIcons.class);
    private static final String ICON_RESOURCE_PATH_BASE = "net/utoolity/atlassian/ifaws/svg/";
    public static final String GENERIC_ICON_RESOURCE_PATH = "net/utoolity/atlassian/ifaws/svg/genericAwsIcon.svg";
    private static final String SERVICE_ICON_RESOURCE_PATH_TEMPLATE = "net/utoolity/atlassian/ifaws/svg/%sServiceIcon.svg";
    private static final String AWS_ICON_RESOURCE_URL_BASE = PluginInfo.PLUGIN_RESOURCE_BASE_URL + "ifaws-main-web-resource/svg/";
    private static final String AWS_ICON_RESOURCE_URL_GENERIC = AWS_ICON_RESOURCE_URL_BASE + "genericAwsIcon.svg";
    private static final String AWS_ICON_RESOURCE_URL_SERVICE_TEMPLATE = AWS_ICON_RESOURCE_URL_BASE + "%sServiceIcon.svg";

    public static String mapServiceKeyToIconPrefix(String service) {
        String iconPrefix = SERVICE_ICON_NAME_DEVIATIONS.get(service);
        return null != iconPrefix ? iconPrefix : service;
    }

    public static boolean hasOwnIcon(String service) {
        String expectedResourceName = String.format(SERVICE_ICON_RESOURCE_PATH_TEMPLATE, AWSIcons.mapServiceKeyToIconPrefix(service));
        URL resourceUrl = ClassLoaderUtils.getResource((String)expectedResourceName, AWSIcons.class);
        return null != resourceUrl;
    }

    public static String getIconUrlForService(String service) {
        if (AWSIcons.hasOwnIcon(service)) {
            return String.format(AWS_ICON_RESOURCE_URL_SERVICE_TEMPLATE, AWSIcons.mapServiceKeyToIconPrefix(service));
        }
        return AWSIcons.getIconUrlGeneric();
    }

    public static String getIconUrlGeneric() {
        return AWS_ICON_RESOURCE_URL_GENERIC;
    }
}

