/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.api.impl;

import java.util.ArrayList;
import java.util.List;
import net.utoolity.atlassian.dry.LicenseHelper;
import net.utoolity.atlassian.ifaws.api.AWSConnectorService2;
import net.utoolity.atlassian.ifaws.api.ECRCredentialsDTO;
import net.utoolity.atlassian.ifaws.api.ECRCredentialsService;
import net.utoolity.atlassian.ifaws.api.LicenseException;
import net.utoolity.atlassian.ifaws.api.NotAuthorizedException;
import net.utoolity.atlassian.ifaws.api.STSCredentialsDTO;
import net.utoolity.atlassian.ifaws.aws.ECR;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;

public class ECRCredentialsServiceImpl
implements ECRCredentialsService {
    private final LicenseHelper licenseHelper;
    private final AWSConnectorService2 awsConnectorService2;

    public ECRCredentialsServiceImpl(LicenseHelper licenseHelper, AWSConnectorService2 awsConnectorService2) {
        this.licenseHelper = licenseHelper;
        this.awsConnectorService2 = awsConnectorService2;
    }

    @Override
    public ECRCredentialsDTO getCredentials(String connectorId) throws NotAuthorizedException, LicenseException {
        ArrayList<String> registryIds = new ArrayList<String>();
        String regionName = null;
        List<ECRCredentialsDTO> credentialsList = this.getCredentials(connectorId, registryIds, regionName);
        return credentialsList.get(0);
    }

    @Override
    public ECRCredentialsDTO getCredentials(String connectorId, String regionName) throws NotAuthorizedException, LicenseException {
        ArrayList<String> registryIds = new ArrayList<String>();
        List<ECRCredentialsDTO> credentialsList = this.getCredentials(connectorId, registryIds, regionName);
        return credentialsList.get(0);
    }

    @Override
    public List<ECRCredentialsDTO> getCredentials(String connectorId, List<String> registryIds) throws NotAuthorizedException, LicenseException {
        String regionName = null;
        return this.getCredentials(connectorId, registryIds, regionName);
    }

    @Override
    public List<ECRCredentialsDTO> getCredentials(String connectorId, List<String> registryIds, String regionName) throws NotAuthorizedException, LicenseException {
        this.licenseHelper.ensureValidLicense();
        STSCredentialsDTO stsCredentialsDTO = this.awsConnectorService2.getCredentials(connectorId);
        if (null == stsCredentialsDTO) {
            return null;
        }
        AwsSessionCredentials awsCredentials = AwsSessionCredentials.create((String)stsCredentialsDTO.getAccessKeyId(), (String)stsCredentialsDTO.getSecretAccessKey(), (String)stsCredentialsDTO.getSessionToken());
        List<ECRCredentialsDTO> ecrCredentialsDTOList = ECR.getECRCredentials(awsCredentials, registryIds, regionName);
        return ecrCredentialsDTOList;
    }
}

