/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.api.impl;

import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import net.utoolity.atlassian.dry.LicenseHelper;
import net.utoolity.atlassian.ifaws.AWSSecurityTokenClientProxy;
import net.utoolity.atlassian.ifaws.FeatureFlag;
import net.utoolity.atlassian.ifaws.PluginConfiguration;
import net.utoolity.atlassian.ifaws.ao.AWSConnectorGroup;
import net.utoolity.atlassian.ifaws.ao.AWSConnectorPersistenceService;
import net.utoolity.atlassian.ifaws.api.AWSConnectorScope;
import net.utoolity.atlassian.ifaws.api.LicenseException;
import net.utoolity.atlassian.ifaws.api.NotAuthorizedException;
import net.utoolity.atlassian.ifaws.api.STSCallerIdentityDTO;
import net.utoolity.atlassian.ifaws.api.STSCredentialsDTO;
import net.utoolity.atlassian.ifaws.model.AWSConnectorEntity;
import org.apache.commons.lang3.StringUtils;
import software.amazon.awssdk.services.sts.model.Credentials;

public class AWSConnectorService2ImplBase {
    private static final String STS_SYSTEM_USER_NAME = "SYSTEM";
    protected final LicenseHelper licenseHelper;
    protected final AWSConnectorPersistenceService awsConnectorPersistenceService;
    protected final AWSSecurityTokenClientProxy tokenClientProxy;
    protected final PluginConfiguration pluginConfiguration;
    protected final UserManager userManager;

    public AWSConnectorService2ImplBase(LicenseHelper licenseHelper, AWSConnectorPersistenceService awsConnectorPersistenceService, AWSSecurityTokenClientProxy tokenClientProxy, UserManager userManager, PluginConfiguration pluginConfiguration) {
        this.licenseHelper = licenseHelper;
        this.awsConnectorPersistenceService = awsConnectorPersistenceService;
        this.tokenClientProxy = tokenClientProxy;
        this.userManager = userManager;
        this.pluginConfiguration = pluginConfiguration;
    }

    public STSCredentialsDTO getCredentials(String connectorId) throws NotAuthorizedException, LicenseException {
        return this.getCredentials(connectorId, null, null);
    }

    public STSCredentialsDTO getCredentials(String connectorId, AWSConnectorScope awsConnectorScope) throws NotAuthorizedException, LicenseException {
        return this.getCredentials(connectorId, null, awsConnectorScope);
    }

    public STSCredentialsDTO getCredentials(String connectorId, Integer durationSeconds) throws NotAuthorizedException, LicenseException {
        return this.getCredentials(connectorId, durationSeconds, null);
    }

    public STSCredentialsDTO getCredentials(String connectorId, Integer durationSeconds, AWSConnectorScope awsConnectorScope) throws NotAuthorizedException, LicenseException {
        this.licenseHelper.ensureValidLicense();
        UserKey userKey = this.findCurrentUserKey();
        AWSConnectorEntity awsConnector = this.awsConnectorPersistenceService.getById(connectorId);
        if (null == awsConnector) {
            return null;
        }
        if (!this.hasAccess(userKey, awsConnector, awsConnectorScope)) {
            throw new NotAuthorizedException("Requesting user is not authorized to access this Connector");
        }
        String userName = this.findCurrentUserName();
        if (StringUtils.isBlank((CharSequence)userName)) {
            userName = awsConnector.getName();
        }
        Credentials credentials = this.tokenClientProxy.getSecurityToken(awsConnector, durationSeconds, userName);
        return new STSCredentialsDTO(credentials.accessKeyId(), credentials.secretAccessKey(), credentials.sessionToken(), credentials.expiration(), awsConnector.getCloudProvider().getPartitionKey());
    }

    protected UserKey findCurrentUserKey() {
        return this.userManager.getRemoteUserKey();
    }

    private String findCurrentUserName() {
        UserProfile userProfile = this.userManager.getRemoteUser();
        if (null != userProfile) {
            return userProfile.getUsername();
        }
        return STS_SYSTEM_USER_NAME;
    }

    protected boolean hasAccess(UserKey userKey, AWSConnectorEntity awsConnector, AWSConnectorScope awsConnectorScope) {
        AWSConnectorGroup[] groups;
        if (null != awsConnectorScope && awsConnector.hasScope(awsConnectorScope)) {
            return true;
        }
        if (null == userKey) {
            return false;
        }
        for (AWSConnectorGroup group : groups = awsConnector.getGroups()) {
            if (!this.userManager.isUserInGroup(userKey, group.getName())) continue;
            return true;
        }
        if (this.pluginConfiguration.isFeatureEnabled(FeatureFlag.DISABLE_IMPLICIT_ADMIN_CONNECTOR_USAGE)) {
            return false;
        }
        boolean enableRestrictedAdminConnectorManagement = this.pluginConfiguration.isFeatureEnabled(FeatureFlag.ENABLE_RESTRICTED_ADMIN_CONNECTOR_MANAGEMENT);
        if (enableRestrictedAdminConnectorManagement) {
            return this.userManager.isAdmin(userKey);
        }
        return this.userManager.isSystemAdmin(userKey);
    }

    public STSCallerIdentityDTO getCallerIdentity(String connectorId) throws NotAuthorizedException, LicenseException {
        STSCallerIdentityDTO stsCallerIdentityDTO = null;
        STSCredentialsDTO stsCredentialsDTO = this.getCredentials(connectorId);
        if (null != stsCredentialsDTO) {
            stsCallerIdentityDTO = this.tokenClientProxy.getCallerIdentity(stsCredentialsDTO);
        }
        return stsCallerIdentityDTO;
    }
}

