/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.api;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.utoolity.atlassian.dry.StaticComponentAccessor;
import net.utoolity.atlassian.ifaws.PluginConfiguration;
import net.utoolity.atlassian.ifaws.api.impl.ExternalCredentialsProviderServiceImpl;
import net.utoolity.atlassian.ifaws.aws.EC2ContainerCredentialsProviderWrapper;
import net.utoolity.atlassian.ifaws.model.AWSAccountEntity;
import net.utoolity.atlassian.ifaws.model.ExternalCredentialsProviderType;
import org.apache.commons.lang3.NotImplementedException;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.WebIdentityTokenFileCredentialsProvider;

public interface ExternalCredentialsProviderService {
    public void createPlaceholderAccount(ExternalCredentialsProviderType var1);

    public void deletePlaceholderAccount(ExternalCredentialsProviderType var1);

    public boolean canDeletePlaceholderAccount(ExternalCredentialsProviderType var1);

    public boolean isPlaceholderAccountId(String var1);

    public boolean isExternalCredentialsProviderSourceEnabled(ExternalCredentialsProviderType var1);

    public void enableExternalCredentialsProviderSource(ExternalCredentialsProviderType var1);

    public void disableExternalCredentialsProviderSource(ExternalCredentialsProviderType var1);

    public String getPlaceholderAccountId(ExternalCredentialsProviderType var1);

    public static boolean isExternalCredentialsProviderSourceSupported(ExternalCredentialsProviderType externalCredentialsProviderType) {
        try {
            AwsCredentialsProvider credentialsProvider = ExternalCredentialsProviderService.getExternalCredentialsProvider(externalCredentialsProviderType);
            AwsCredentials credentials = credentialsProvider.resolveCredentials();
            return credentials != null;
        }
        catch (Exception e) {
            ExternalCredentialsProviderServiceImpl.log.info("Can not retrieve AWSCredentialsProvider for externalCredentialsProvider, assuming not available", (Throwable)e);
            return false;
        }
    }

    public static Map<String, ExternalCredentialsProviderType> getPlaceholderAccountIds(PluginConfiguration pluginConfiguration) {
        HashMap<String, ExternalCredentialsProviderType> placeholderAccountIds = new HashMap<String, ExternalCredentialsProviderType>();
        for (ExternalCredentialsProviderType providerType : ExternalCredentialsProviderType.values()) {
            String placeholderAccountId = pluginConfiguration.readStringSetting(providerType.getPlaceholderAccountIdKey());
            if (null == placeholderAccountId) continue;
            placeholderAccountIds.put(placeholderAccountId, providerType);
        }
        return placeholderAccountIds;
    }

    public static boolean isPlaceholderAccount(AWSAccountEntity awsAccountEntity) {
        PluginConfiguration pluginConfiguration = StaticComponentAccessor.getPluginConfiguration();
        Set<String> placeholderAccountIds = ExternalCredentialsProviderService.getPlaceholderAccountIds(pluginConfiguration).keySet();
        return placeholderAccountIds.size() > 0 && placeholderAccountIds.contains(awsAccountEntity.getId());
    }

    public static AwsCredentialsProvider getExternalCredentialsProvider(AWSAccountEntity awsAccount) {
        PluginConfiguration pluginConfiguration = StaticComponentAccessor.getPluginConfiguration();
        Map<String, ExternalCredentialsProviderType> placeholderAccountIds = ExternalCredentialsProviderService.getPlaceholderAccountIds(pluginConfiguration);
        return ExternalCredentialsProviderService.getExternalCredentialsProvider(placeholderAccountIds.get(awsAccount.getId()));
    }

    public static AwsCredentialsProvider getExternalCredentialsProvider(ExternalCredentialsProviderType externalCredentialsProviderType) {
        switch (externalCredentialsProviderType) {
            case IAMRoleForEC2AndECS: {
                EC2ContainerCredentialsProviderWrapper credentialsProvider = new EC2ContainerCredentialsProviderWrapper();
                return credentialsProvider;
            }
            case WebIdentityToken: {
                return WebIdentityTokenFileCredentialsProvider.create();
            }
        }
        throw new NotImplementedException(String.format("Credentials retrieval for ExternalCredentialsProviderType %s not yet implemented", new Object[]{externalCredentialsProviderType}));
    }
}

