/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.api;

import java.io.UnsupportedEncodingException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.ecr.model.AuthorizationData;
import software.amazon.awssdk.utils.BinaryUtils;

@XmlRootElement(name="credentials")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ECRCredentialsDTO {
    private static final Logger log = LoggerFactory.getLogger(ECRCredentialsDTO.class);
    @XmlElement(name="authorizationToken")
    private final String authorizationToken;
    @XmlElement(name="expirationDate")
    private final String expirationDate;
    @XmlElement(name="proxyEndpoint")
    private final String proxyEndpoint;
    @XmlElement(name="proxyEndpointDomain")
    private final String proxyEndpointDomain;
    @XmlElement(name="username")
    private final String username;
    @XmlElement(name="password")
    private final String password;

    public ECRCredentialsDTO(AuthorizationData authorizationData) {
        this.authorizationToken = authorizationData.authorizationToken();
        this.expirationDate = this.formatISODateTime(authorizationData.expiresAt());
        this.proxyEndpoint = authorizationData.proxyEndpoint();
        this.proxyEndpointDomain = this.proxyEndpoint.replaceFirst("https://", "");
        String[] decodedAndSplittedAuthorizationToken = this.decodeAndSplitAuthorizationToken(this.authorizationToken);
        this.username = decodedAndSplittedAuthorizationToken[0];
        this.password = decodedAndSplittedAuthorizationToken[1];
    }

    private String formatISODateTime(Instant instant) {
        return DateTimeFormatter.ISO_INSTANT.format(instant.truncatedTo(ChronoUnit.SECONDS));
    }

    private String[] decodeAndSplitAuthorizationToken(String token) {
        String[] splittedResult = null;
        byte[] decoded = BinaryUtils.fromBase64((String)token);
        try {
            String decodedAsString = new String(decoded, "UTF-8");
            splittedResult = decodedAsString.split(":", 2);
        }
        catch (UnsupportedEncodingException e) {
            log.error("Error decoding Base64 authorization token", (Throwable)e);
        }
        return splittedResult;
    }

    public String getAuthorizationToken() {
        return this.authorizationToken;
    }

    public String getExpirationDate() {
        return this.expirationDate;
    }

    public String getProxyEndpoint() {
        return this.proxyEndpoint;
    }

    public String getProxyEndpointDomain() {
        return this.proxyEndpointDomain;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

