/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.api;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import software.amazon.awssdk.services.codeartifact.model.GetAuthorizationTokenResponse;

@XmlRootElement(name="credentials")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CodeArtifactCredentialsDTO {
    @XmlElement(name="authorizationToken")
    private final String authorizationToken;
    @XmlElement(name="expirationDate")
    private final String expirationDate;

    public CodeArtifactCredentialsDTO(GetAuthorizationTokenResponse getAuthorizationTokenResult) {
        this.authorizationToken = getAuthorizationTokenResult.authorizationToken();
        this.expirationDate = this.formatISODateTime(getAuthorizationTokenResult.expiration());
    }

    private String formatISODateTime(Instant instant) {
        return DateTimeFormatter.ISO_INSTANT.format(instant.truncatedTo(ChronoUnit.SECONDS));
    }

    public String getAuthorizationToken() {
        return this.authorizationToken;
    }

    public String getExpirationDate() {
        return this.expirationDate;
    }
}

