/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.dry;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import java.io.IOException;
import java.net.URI;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.utoolity.atlassian.ifaws.PluginConfiguration;

public abstract class AccessServletFilterBase
implements Filter {
    static final String JIRA_SERAPH_SECURITY_ORIGINAL_URL = "os_security_originalurl";
    static final String CONF_SERAPH_SECURITY_ORIGINAL_URL = "seraph_originalurl";
    static final String INIT_PARAM_REDIRECT_TO_LOGIN = "redirect_to_login";
    protected final UserManager userManager;
    protected final LoginUriProvider loginUriProvider;
    protected final PluginConfiguration pluginConfiguration;
    private FilterConfig filterConfig;

    public AccessServletFilterBase(UserManager userManager, LoginUriProvider loginUriProvider, PluginConfiguration pluginConfiguration) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.pluginConfiguration = pluginConfiguration;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String method = httpRequest.getMethod();
        UserKey userKey = this.userManager.getRemoteUserKey((HttpServletRequest)request);
        if (!this.isUserAllowed(userKey, method)) {
            String redirectToLogin = this.filterConfig.getInitParameter(INIT_PARAM_REDIRECT_TO_LOGIN);
            if (Boolean.parseBoolean(redirectToLogin)) {
                URI requestUri = this.getUri((HttpServletRequest)request);
                this.addSessionAttributes((HttpServletRequest)request, requestUri.toASCIIString());
                ((HttpServletResponse)response).sendRedirect(this.loginUriProvider.getLoginUri(requestUri).toASCIIString());
            } else {
                ((HttpServletResponse)response).sendError(403);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    private void addSessionAttributes(HttpServletRequest request, String uriString) {
        request.getSession().setAttribute(JIRA_SERAPH_SECURITY_ORIGINAL_URL, (Object)uriString);
        request.getSession().setAttribute(CONF_SERAPH_SECURITY_ORIGINAL_URL, (Object)uriString);
    }

    public void destroy() {
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    protected abstract boolean isUserAllowed(UserKey var1, String var2);
}

