/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.bamboo.ifaws;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.utils.i18n.I18nBeanFactory;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import net.utoolity.atlassian.bamboo.ifaws.BaseTask;
import net.utoolity.atlassian.bamboo.ifaws.BaseTaskConfigurator;
import net.utoolity.atlassian.ifaws.ao.DefaultCloudProvider;
import net.utoolity.atlassian.ifaws.api.ECRCredentialsDTO;
import net.utoolity.atlassian.ifaws.aws.ECR;
import org.apache.commons.lang3.StringUtils;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.exception.SdkException;

public class ECRCredentialsVariablesTask
extends BaseTask {
    private static final String ECR_NAMESPACE = ".ecr";
    private static final String VARIABLE_NAME_ECR_AUTHORIZATION_TOKEN_PASSWORD = ".ecr.authorizationToken.password";
    private static final String VARIABLE_NAME_ECR_EXPIRATION_DATE = ".ecr.expirationDate";
    private static final String VARIABLE_NAME_ECR_PROXY_ENDPOINT = ".ecr.proxyEndpoint";
    private static final String VARIABLE_NAME_ECR_PROXY_ENDPOINT_DOMAIN = ".ecr.proxyEndpointDomain";
    private static final String VARIABLE_NAME_ECR_USERNAME = ".ecr.username";
    private static final String VARIABLE_NAME_ECR_PASSWORD = ".ecr.password";
    private static final String VARIABLE_NAME_ECR_CREDENTIALS_JSON_PASSWORD = ".ecr.credentials.json.password";

    public ECRCredentialsVariablesTask(CustomVariableContext customVariableContext, I18nBeanFactory i18nBeanFactory) {
        super(customVariableContext, i18nBeanFactory);
    }

    @Override
    protected TaskResult execute(TaskResultBuilder taskResultBuilder, ConfigurationMap configurationMap, BuildLogger buildLogger, CommonTaskContext commonTaskContext, AwsCredentialsProvider awsCredentialsProvider, DefaultCloudProvider cloudProvider, ClientOverrideConfiguration clientConfiguration) throws TaskException {
        String region = BaseTaskConfigurator.extractRegionFromConfigurationMap(configurationMap);
        if (StringUtils.isNotBlank((CharSequence)region)) {
            buildLogger.addBuildLogEntry("Selecting region " + region);
        }
        String registryId = (String)configurationMap.get((Object)"registryId");
        ArrayList<String> registryIds = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)registryId)) {
            registryIds.add(registryId);
        }
        try {
            List<ECRCredentialsDTO> credentialsList = ECR.getECRCredentials(awsCredentialsProvider, registryIds, region, clientConfiguration);
            if (credentialsList.isEmpty()) {
                buildLogger.addBuildLogEntry("Failed to get ECR credentials, AWS unexpectedly returned an empty result.");
                taskResultBuilder.failedWithError();
            } else {
                this.createCredentialVariables(commonTaskContext, credentialsList.get(0));
            }
        }
        catch (AwsServiceException ase) {
            buildLogger.addErrorLogEntry("ECR request rejected by AWS!", (Throwable)ase);
            taskResultBuilder.failedWithError();
        }
        catch (SdkException ace) {
            buildLogger.addErrorLogEntry("Failed to communicate with AWS!", (Throwable)ace);
            taskResultBuilder.failedWithError();
        }
        catch (Exception e) {
            buildLogger.addErrorLogEntry("Failed to fetch resource from AWS!", (Throwable)e);
            taskResultBuilder.failedWithError();
        }
        return taskResultBuilder.build();
    }

    private void createCredentialVariables(CommonTaskContext commonTaskContext, ECRCredentialsDTO ecrCredentialsDTO) {
        BuildLogger buildLogger = commonTaskContext.getBuildLogger();
        buildLogger.addBuildLogEntry("Creating variables for retrieved ECR credentials:");
        this.createAndLogVariable(buildLogger, VARIABLE_NAME_ECR_AUTHORIZATION_TOKEN_PASSWORD, ecrCredentialsDTO.getAuthorizationToken());
        this.createAndLogVariable(buildLogger, VARIABLE_NAME_ECR_EXPIRATION_DATE, ecrCredentialsDTO.getExpirationDate());
        this.createAndLogVariable(buildLogger, VARIABLE_NAME_ECR_PROXY_ENDPOINT, ecrCredentialsDTO.getProxyEndpoint());
        this.createAndLogVariable(buildLogger, VARIABLE_NAME_ECR_PROXY_ENDPOINT_DOMAIN, ecrCredentialsDTO.getProxyEndpointDomain());
        this.createAndLogVariable(buildLogger, VARIABLE_NAME_ECR_USERNAME, ecrCredentialsDTO.getUsername());
        this.createAndLogVariable(buildLogger, VARIABLE_NAME_ECR_PASSWORD, ecrCredentialsDTO.getPassword());
        String credentialsJson = new Gson().toJson((Object)ecrCredentialsDTO);
        this.createAndLogVariable(buildLogger, VARIABLE_NAME_ECR_CREDENTIALS_JSON_PASSWORD, credentialsJson);
    }
}

