/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.bamboo.ifaws;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.utils.i18n.I18nBeanFactory;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.google.gson.Gson;
import net.utoolity.atlassian.bamboo.ifaws.BaseTask;
import net.utoolity.atlassian.bamboo.ifaws.BaseTaskConfigurator;
import net.utoolity.atlassian.ifaws.ao.DefaultCloudProvider;
import net.utoolity.atlassian.ifaws.api.CodeArtifactCredentialsDTO;
import net.utoolity.atlassian.ifaws.aws.CodeArtifact;
import org.apache.commons.lang3.StringUtils;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.exception.SdkException;

public class CodeArtifactCredentialsVariablesTask
extends BaseTask {
    private static final String CODE_ARTIFACT_NAMESPACE = ".codeartifact";
    private static final String VARIABLE_NAME_CODE_ARTIFACT_AUTHORIZATION_TOKEN_PASSWORD = ".codeartifact.authorizationToken.password";
    private static final String VARIABLE_NAME_CODE_ARTIFACT_EXPIRATION_DATE = ".codeartifact.expirationDate";
    private static final String VARIABLE_NAME_CODE_ARTIFACT_CREDENTIALS_JSON_PASSWORD = ".codeartifact.credentials.json.password";

    public CodeArtifactCredentialsVariablesTask(CustomVariableContext customVariableContext, I18nBeanFactory i18nBeanFactory) {
        super(customVariableContext, i18nBeanFactory);
    }

    @Override
    protected TaskResult execute(TaskResultBuilder taskResultBuilder, ConfigurationMap configurationMap, BuildLogger buildLogger, CommonTaskContext commonTaskContext, AwsCredentialsProvider awsCredentialsProvider, DefaultCloudProvider cloudProvider, ClientOverrideConfiguration clientConfiguration) throws TaskException {
        String regionName = BaseTaskConfigurator.extractRegionFromConfigurationMap(configurationMap);
        if (StringUtils.isNotBlank((CharSequence)regionName)) {
            buildLogger.addBuildLogEntry("Selecting region " + regionName);
        }
        String domain = (String)configurationMap.get((Object)"domain");
        String domainOwner = (String)configurationMap.get((Object)"domainOwner");
        Integer durationSeconds = null;
        String durationSecondsString = (String)configurationMap.get((Object)"durationSeconds");
        if (StringUtils.isNotBlank((CharSequence)durationSecondsString)) {
            durationSeconds = Integer.parseInt(durationSecondsString);
        }
        try {
            CodeArtifactCredentialsDTO codeArtifactCredentialsDTO = CodeArtifact.getCodeArtifactCredentials(awsCredentialsProvider, domain, domainOwner, durationSeconds, regionName, null);
            this.createCredentialVariables(commonTaskContext, codeArtifactCredentialsDTO);
        }
        catch (AwsServiceException ase) {
            buildLogger.addErrorLogEntry("CodeArtifact request rejected by AWS!", (Throwable)ase);
            taskResultBuilder.failedWithError();
        }
        catch (SdkException ace) {
            buildLogger.addErrorLogEntry("Failed to communicate with AWS!", (Throwable)ace);
            taskResultBuilder.failedWithError();
        }
        catch (Exception e) {
            buildLogger.addErrorLogEntry("Failed to fetch resource from AWS!", (Throwable)e);
            taskResultBuilder.failedWithError();
        }
        return taskResultBuilder.build();
    }

    private void createCredentialVariables(CommonTaskContext commonTaskContext, CodeArtifactCredentialsDTO codeArtifactCredentialsDTO) {
        BuildLogger buildLogger = commonTaskContext.getBuildLogger();
        buildLogger.addBuildLogEntry("Creating variables for retrieved CodeArtifact credentials:");
        this.createAndLogVariable(buildLogger, VARIABLE_NAME_CODE_ARTIFACT_AUTHORIZATION_TOKEN_PASSWORD, codeArtifactCredentialsDTO.getAuthorizationToken());
        this.createAndLogVariable(buildLogger, VARIABLE_NAME_CODE_ARTIFACT_EXPIRATION_DATE, codeArtifactCredentialsDTO.getExpirationDate());
        String credentialsJson = new Gson().toJson((Object)codeArtifactCredentialsDTO);
        this.createAndLogVariable(buildLogger, VARIABLE_NAME_CODE_ARTIFACT_CREDENTIALS_JSON_PASSWORD, credentialsJson);
    }
}

