/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.sso;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Map;
import net.utoolity.atlassian.ifaws.ao.DefaultCloudProvider;
import net.utoolity.atlassian.ifaws.api.AWSConnectorService2;
import net.utoolity.atlassian.ifaws.api.STSCredentialsDTO;
import net.utoolity.atlassian.ifaws.sso.CreateSSORedirectUrlRequest;
import net.utoolity.atlassian.ifaws.sso.CreateSSORedirectUrlResponse;
import net.utoolity.atlassian.ifaws.sso.InvalidDestinationUrlException;
import net.utoolity.atlassian.ifaws.sso.MissingConnectorIdException;
import net.utoolity.atlassian.ifaws.sso.NonAwsDestinationUrlException;
import net.utoolity.atlassian.ifaws.sso.UnknownConnectorIdException;
import org.apache.commons.lang3.StringUtils;
import software.amazon.awssdk.core.exception.SdkClientException;

public class AWSConsoleLoginProxy {
    private final AWSConnectorService2 awsConnectorService2;
    private String signInTokenForOfflineTesting = null;

    public AWSConsoleLoginProxy(AWSConnectorService2 awsConnectorService2) {
        this.awsConnectorService2 = awsConnectorService2;
    }

    public void setSignInTokenForOfflineTesting(String testToken) {
        this.signInTokenForOfflineTesting = testToken;
    }

    public CreateSSORedirectUrlResponse createSSORedirectUrl(CreateSSORedirectUrlRequest request) {
        CreateSSORedirectUrlResponse response = new CreateSSORedirectUrlResponse();
        try {
            this.validateSSORedirectUrlRequest(request);
            String ssoUrl = this.buildTempAWSConsoleLoginURI(request.getConnectorId(), request.getIssuerUrl(), request.getDestinationUrl());
            response.setSSOUrl(ssoUrl);
        }
        catch (Exception e) {
            response.setError(e);
            response.setNonSSOFallbackUrl(this.createNonSSOFallbackUrl(request, e));
        }
        return response;
    }

    private void validateSSORedirectUrlRequest(CreateSSORedirectUrlRequest request) {
        if (StringUtils.isBlank((CharSequence)request.getConnectorId())) {
            throw new MissingConnectorIdException();
        }
        if (StringUtils.isNotBlank((CharSequence)request.getDestinationUrl())) {
            this.verifyAwsConsoleUrlOnly(request.getDestinationUrl());
        }
    }

    private String createNonSSOFallbackUrl(CreateSSORedirectUrlRequest request, Exception e) {
        if (e instanceof NonAwsDestinationUrlException || e instanceof InvalidDestinationUrlException) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)request.getDestinationUrl())) {
            return request.getDestinationUrl();
        }
        return DefaultCloudProvider.AWS.getManagementConsoleURL();
    }

    private String buildTempAWSConsoleLoginURI(String idParam, String issuerURL, String destinationUrlUnencoded) {
        String loginURL;
        String getSigninTokenURL;
        STSCredentialsDTO stsCredentials = this.awsConnectorService2.getCredentials(idParam);
        if (null == stsCredentials) {
            String message = String.format("Could not retrieve credentials based on connector id '%s'", idParam);
            throw new UnknownConnectorIdException(message);
        }
        DefaultCloudProvider cloudProvider = DefaultCloudProvider.getByPartitionKey(stsCredentials.getPartition());
        String sessionJson = String.format("{\"%1$s\":\"%2$s\",\"%3$s\":\"%4$s\",\"%5$s\":\"%6$s\"}", "sessionId", stsCredentials.getAccessKeyId(), "sessionKey", stsCredentials.getSecretAccessKey(), "sessionToken", stsCredentials.getSessionToken());
        try {
            getSigninTokenURL = cloudProvider.getSigninURL() + "?Action=getSigninToken&SessionType=json&Session=" + URLEncoder.encode(sessionJson, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        String signinToken = this.tryGetSigninToken(getSigninTokenURL);
        try {
            String signinTokenParameter = "&SigninToken=" + URLEncoder.encode(signinToken, "UTF-8");
            String issuerParameter = "";
            if (null != issuerURL) {
                issuerParameter = "&Issuer=" + URLEncoder.encode(issuerURL, "UTF-8");
            }
            String destinationUrlEncoded = URLEncoder.encode(cloudProvider.getManagementConsoleURL(), "UTF-8");
            if (StringUtils.isNotBlank((CharSequence)destinationUrlUnencoded)) {
                destinationUrlEncoded = URLEncoder.encode(destinationUrlUnencoded, "UTF-8");
            }
            String destinationParameter = "&Destination=" + destinationUrlEncoded;
            loginURL = cloudProvider.getSigninURL() + "?Action=login" + signinTokenParameter + issuerParameter + destinationParameter;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return loginURL;
    }

    private String tryGetSigninToken(String getSigninTokenURL) {
        String signinToken;
        String returnContent;
        URLConnection conn;
        URL url;
        if (null != this.signInTokenForOfflineTesting) {
            return this.signInTokenForOfflineTesting;
        }
        try {
            url = new URL(getSigninTokenURL);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        try {
            conn = url.openConnection();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            BufferedReader bufferReader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            returnContent = bufferReader.readLine();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Map responseMap = this.fromJsonString(returnContent, Map.class);
        try {
            signinToken = (String)responseMap.get("SigninToken");
            if (StringUtils.isBlank((CharSequence)signinToken)) {
                throw new RuntimeException("Could not find signinToken in getSigninToken response: " + returnContent);
            }
        }
        catch (ClassCastException cce) {
            throw new RuntimeException("Could not extract signinToken string from getSigninToken response: " + returnContent, cce);
        }
        return signinToken;
    }

    private <T> T fromJsonString(String json, Class<T> clazz) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        if (json == null) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(json, clazz);
        }
        catch (Exception e) {
            throw SdkClientException.create((String)"Unable to parse Json String.", (Throwable)e);
        }
    }

    private void verifyAwsConsoleUrlOnly(String destinationUrl) {
        URI uri = null;
        try {
            uri = new URL(destinationUrl).toURI();
        }
        catch (MalformedURLException e) {
            throw new InvalidDestinationUrlException();
        }
        catch (URISyntaxException e) {
            throw new InvalidDestinationUrlException();
        }
        boolean isAwsConsoleUrl = false;
        String hostString = uri.getHost();
        if (StringUtils.isBlank((CharSequence)hostString)) {
            throw new InvalidDestinationUrlException();
        }
        for (DefaultCloudProvider defaultCloudProvider : DefaultCloudProvider.values()) {
            String nonRegionedHostString = defaultCloudProvider.getManagementConsoleURL().replace("https://", "").replace("/", "");
            if (!hostString.contains(nonRegionedHostString)) continue;
            isAwsConsoleUrl = true;
        }
        if (!isAwsConsoleUrl) {
            throw new NonAwsDestinationUrlException();
        }
    }
}

