/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.rest.v2;

import java.text.Collator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeMap;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import net.utoolity.atlassian.dry.GroupAccessor;
import net.utoolity.atlassian.ifaws.rest.v2.AutocompleteGroupDTO;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="/autocomplete/groups")
public class AutocompleteGroupResource {
    private final GroupAccessor groupAccessor;

    @Autowired
    public AutocompleteGroupResource(GroupAccessor groupAccessor) {
        this.groupAccessor = groupAccessor;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getPluginInfo(@DefaultValue(value="") @QueryParam(value="filter") String filter) {
        TreeMap<String, String> filteredMap = this.filterResults(filter);
        LinkedHashSet<AutocompleteGroupDTO> resultSet = new LinkedHashSet<AutocompleteGroupDTO>();
        for (Map.Entry<String, String> entry : filteredMap.entrySet()) {
            resultSet.add(AutocompleteGroupDTO.fromGroupNameAndHashCode(entry.getKey(), entry.getValue()));
        }
        return Response.ok(resultSet).build();
    }

    private TreeMap<String, String> filterResults(String filter) {
        TreeMap<Object, String> resultMapKeyedByName = new TreeMap<Object, String>(Collator.getInstance());
        Map<String, String> allGroupsMapKeyedByName = this.groupAccessor.getGroupsMapKeyedByNameContainingString(filter);
        resultMapKeyedByName.putAll(allGroupsMapKeyedByName);
        return resultMapKeyedByName;
    }
}

