/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.rest.v1;

import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import net.utoolity.atlassian.dry.ParameterValidationException;
import net.utoolity.atlassian.ifaws.api.AWSConnectorDTO;
import net.utoolity.atlassian.ifaws.api.AWSConnectorScope;
import net.utoolity.atlassian.ifaws.api.AWSConnectorService;
import net.utoolity.atlassian.ifaws.api.STSCredentialsDTO;
import net.utoolity.atlassian.ifaws.rest.common.DTOCollectionImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="/connectors")
public class AWSConnectorResource {
    private final AWSConnectorService awsConnectorService;

    @Autowired
    public AWSConnectorResource(AWSConnectorService awsConnectorService) {
        this.awsConnectorService = awsConnectorService;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getConnectors(@QueryParam(value="scope") String scopeParam) {
        AWSConnectorScope scope = this.parseScopeParam(scopeParam);
        List<AWSConnectorDTO> connectors = this.awsConnectorService.getConnectors(scope);
        DTOCollectionImpl<AWSConnectorDTO> connectorCollection = new DTOCollectionImpl<AWSConnectorDTO>(connectors);
        return Response.ok(connectorCollection).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    public Response getConnector(@PathParam(value="id") Integer connectorId) {
        AWSConnectorDTO connector = null;
        connector = this.awsConnectorService.getConnector(connectorId);
        if (null == connector) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)connector).build();
    }

    private AWSConnectorScope parseScopeParam(String scopeParam) throws ParameterValidationException {
        AWSConnectorScope scope = null;
        if (StringUtils.isNotBlank((CharSequence)scopeParam)) {
            try {
                scope = AWSConnectorScope.valueOf(scopeParam);
            }
            catch (IllegalArgumentException iae) {
                throw new ParameterValidationException("Unknown scope value: " + scopeParam);
            }
        }
        return scope;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{id}/credentials")
    public Response getCredentials(@PathParam(value="id") Integer connectorId, @QueryParam(value="durationSeconds") Integer durationSeconds) {
        STSCredentialsDTO credentials = this.awsConnectorService.getCredentials((int)connectorId, durationSeconds);
        if (null == credentials) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)credentials).build();
    }
}

