/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.aws;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.utoolity.atlassian.dry.StaticComponentAccessor;
import net.utoolity.atlassian.ifaws.FeatureFlag;
import net.utoolity.atlassian.ifaws.PluginConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.regions.GeneratedServiceMetadataProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.RegionMetadata;
import software.amazon.awssdk.regions.ServiceMetadata;

public final class AWS {
    private static final Logger log = LoggerFactory.getLogger(AWS.class);
    @VisibleForTesting
    public static final Map<String, String> MISSING_REGION_DESCRIPTIONS = new ImmutableMap.Builder().build();

    public static Map<String, String> getRegionMap() {
        return AWS.getRegionMap(null);
    }

    public static Map<String, String> getRegionMap(String endpointPrefix) {
        HashMap<String, String> regionMap = new HashMap<String, String>();
        List<Region> regions = AWS.getRegionsForService(endpointPrefix);
        for (Region region : regions) {
            String partition;
            String name = region.id();
            if (region.isGlobalRegion()) {
                log.warn("Ignoring global region metadata: " + region.toString());
                continue;
            }
            if (region.metadata() == null) {
                log.warn("Ignoring non global region without metadata: " + region.toString());
                continue;
            }
            String description = String.format("%s \u2013 %s", StringUtils.replaceOnce((String)region.metadata().description(), (String)"EU (", (String)"Europe ("), name);
            PluginConfiguration pluginConfiguration = StaticComponentAccessor.getPluginConfiguration();
            boolean isChinaPartitionEnabled = pluginConfiguration.isFeatureEnabled(FeatureFlag.ENABLE_CHINA_PARTITION);
            boolean isGovCloudPartitionEnabled = pluginConfiguration.isFeatureEnabled(FeatureFlag.ENABLE_GOV_CLOUD);
            switch (partition = RegionMetadata.of((Region)region).partition().id()) {
                case "aws": {
                    regionMap.put(name, description);
                    break;
                }
                case "aws-cn": {
                    if (!isChinaPartitionEnabled) break;
                    regionMap.put(name, description);
                    break;
                }
                case "aws-us-gov": {
                    if (!isGovCloudPartitionEnabled) break;
                    regionMap.put(name, description);
                    break;
                }
                case "aws-iso": 
                case "aws-iso-b": 
                case "aws-iso-f": 
                case "aws-eusc": 
                case "us-isof-south-1": {
                    break;
                }
            }
        }
        Ordering valuesAndNaturalKeysOrdering = Ordering.natural().nullsLast().onResultOf(Functions.forMap(regionMap, null)).compound((Comparator)Ordering.natural());
        ImmutableSortedMap sortedMap = ImmutableSortedMap.copyOf(regionMap, (Comparator)valuesAndNaturalKeysOrdering);
        return sortedMap;
    }

    private static List<Region> getRegionsForService(String endpointPrefix) {
        List regions;
        if (null != endpointPrefix) {
            ServiceMetadata serviceMetadata = new GeneratedServiceMetadataProvider().serviceMetadata(endpointPrefix);
            regions = serviceMetadata.regions();
        } else {
            regions = Region.regions();
        }
        return regions;
    }

    public static boolean isValidRegionName(String regionName) {
        try {
            Region region = Region.of((String)regionName);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

