/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.api.impl;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.utoolity.atlassian.ifaws.PluginConfiguration;
import net.utoolity.atlassian.ifaws.ao.AWSAccountPersistenceService;
import net.utoolity.atlassian.ifaws.ao.DefaultCloudProvider;
import net.utoolity.atlassian.ifaws.api.ExternalCredentialsProviderService;
import net.utoolity.atlassian.ifaws.model.AWSAccountEntity;
import net.utoolity.atlassian.ifaws.model.ExternalCredentialsProviderType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.model.GetCallerIdentityRequest;
import software.amazon.awssdk.services.sts.model.GetCallerIdentityResponse;

public class ExternalCredentialsProviderServiceImpl
implements ExternalCredentialsProviderService {
    public static final Logger log = LoggerFactory.getLogger(ExternalCredentialsProviderServiceImpl.class);
    private static final Pattern PARTITION_KEY_EXTRACTION_PATTERN = Pattern.compile("arn:(.*?):.*");
    private final PluginConfiguration pluginConfiguration;
    private final AWSAccountPersistenceService awsAccountPersistenceService;

    public ExternalCredentialsProviderServiceImpl(PluginConfiguration pluginConfiguration, AWSAccountPersistenceService awsAccountPersistenceService) {
        this.pluginConfiguration = pluginConfiguration;
        this.awsAccountPersistenceService = awsAccountPersistenceService;
    }

    @Override
    public void createPlaceholderAccount(ExternalCredentialsProviderType externalCredentialsProviderType) {
        HashMap<String, Object> defaultParams = new HashMap<String, Object>();
        defaultParams.put("NAME", externalCredentialsProviderType.getPlaceholderAccountName());
        defaultParams.put("AWS_ACCESS_KEY_ID", externalCredentialsProviderType.getPlaceholderAccountKeyPlaceholder());
        defaultParams.put("AWS_SECRET_KEY", externalCredentialsProviderType.getPlaceholderAccountKeyPlaceholder());
        defaultParams.put("CLOUD_PROVIDER_KEY", this.determineCloudProviderKey(externalCredentialsProviderType));
        AWSAccountEntity account = this.awsAccountPersistenceService.create(defaultParams);
        this.pluginConfiguration.writeStringSetting(externalCredentialsProviderType.getPlaceholderAccountIdKey(), account.getId());
    }

    @Override
    public void deletePlaceholderAccount(ExternalCredentialsProviderType externalCredentialsProviderType) {
        if (this.placeholderAccountExists(externalCredentialsProviderType)) {
            AWSAccountEntity account = this.getPlaceholderAccount(externalCredentialsProviderType);
            if (this.isPlaceholderAccountInUse(account)) {
                throw new RuntimeException(String.format("Account %s is still used by connectors and can not be deleted", account.getName()));
            }
            this.awsAccountPersistenceService.delete(account);
        }
    }

    @Override
    public boolean canDeletePlaceholderAccount(ExternalCredentialsProviderType externalCredentialsProviderType) {
        AWSAccountEntity account = this.getPlaceholderAccount(externalCredentialsProviderType);
        if (null == account) {
            return true;
        }
        return !this.isPlaceholderAccountInUse(account);
    }

    private boolean isPlaceholderAccountInUse(AWSAccountEntity account) {
        return 1 <= account.getAWSConnectors().length;
    }

    @Override
    public boolean isPlaceholderAccountId(String accountId) {
        Set<String> placeholderAccountIds = ExternalCredentialsProviderService.getPlaceholderAccountIds(this.pluginConfiguration).keySet();
        return placeholderAccountIds.size() > 0 && placeholderAccountIds.contains(accountId);
    }

    @Override
    public boolean isExternalCredentialsProviderSourceEnabled(ExternalCredentialsProviderType externalCredentialsProviderType) {
        return this.placeholderAccountExists(externalCredentialsProviderType);
    }

    @Override
    public void enableExternalCredentialsProviderSource(ExternalCredentialsProviderType externalCredentialsProviderType) {
        this.ensurePlaceholderAccountEntry(externalCredentialsProviderType);
    }

    @Override
    public void disableExternalCredentialsProviderSource(ExternalCredentialsProviderType externalCredentialsProviderType) {
        this.deletePlaceholderAccount(externalCredentialsProviderType);
    }

    private void ensurePlaceholderAccountEntry(ExternalCredentialsProviderType externalCredentialsProviderType) {
        if (!this.placeholderAccountExists(externalCredentialsProviderType)) {
            this.createPlaceholderAccount(externalCredentialsProviderType);
        }
    }

    private boolean placeholderAccountExists(ExternalCredentialsProviderType externalCredentialsProviderType) {
        return null != this.getPlaceholderAccount(externalCredentialsProviderType);
    }

    private AWSAccountEntity getPlaceholderAccount(ExternalCredentialsProviderType externalCredentialsProviderType) {
        String accountId = this.getPlaceholderAccountId(externalCredentialsProviderType);
        if (StringUtils.isNotBlank((CharSequence)accountId)) {
            return this.awsAccountPersistenceService.getById(accountId);
        }
        return null;
    }

    @Override
    public String getPlaceholderAccountId(ExternalCredentialsProviderType externalCredentialsProviderType) {
        return this.pluginConfiguration.readStringSetting(externalCredentialsProviderType.getPlaceholderAccountIdKey());
    }

    private String determineCloudProviderKey(ExternalCredentialsProviderType externalCredentialsProviderType) {
        AwsCredentialsProvider credentialsProvider = ExternalCredentialsProviderService.getExternalCredentialsProvider(externalCredentialsProviderType);
        StsClient sts = (StsClient)((StsClientBuilder)StsClient.builder().credentialsProvider(credentialsProvider)).build();
        GetCallerIdentityRequest getCallerIdentityRequest = (GetCallerIdentityRequest)GetCallerIdentityRequest.builder().build();
        String arn = null;
        try {
            GetCallerIdentityResponse response = sts.getCallerIdentity(getCallerIdentityRequest);
            arn = response.arn();
        }
        catch (Exception e) {
            log.error("Failed to get caller identity for partition determination:", (Throwable)e);
        }
        String partitionKey = this.extractPartitionKeyFromKeyARN(arn);
        return StringUtils.isNotBlank((CharSequence)partitionKey) ? partitionKey : DefaultCloudProvider.AWS.getPartitionKey();
    }

    @VisibleForTesting
    public String extractPartitionKeyFromKeyARN(String arn) {
        String partitionKey = null;
        try {
            Matcher matcher = PARTITION_KEY_EXTRACTION_PATTERN.matcher(arn);
            matcher.find();
            partitionKey = matcher.group(1);
        }
        catch (Exception e) {
            log.error("Failed to extract partition key from ARN: " + arn);
        }
        return StringUtils.isNotBlank((CharSequence)partitionKey) ? partitionKey : null;
    }
}

