/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.api.impl;

import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import java.util.ArrayList;
import java.util.List;
import net.utoolity.atlassian.dry.LicenseHelper;
import net.utoolity.atlassian.ifaws.AWSSecurityTokenClientProxy;
import net.utoolity.atlassian.ifaws.PluginConfiguration;
import net.utoolity.atlassian.ifaws.ao.AWSConnectorPersistenceService;
import net.utoolity.atlassian.ifaws.api.AWSConnectorDTO2;
import net.utoolity.atlassian.ifaws.api.AWSConnectorScope;
import net.utoolity.atlassian.ifaws.api.AWSConnectorService2;
import net.utoolity.atlassian.ifaws.api.LicenseException;
import net.utoolity.atlassian.ifaws.api.NotAuthorizedException;
import net.utoolity.atlassian.ifaws.api.impl.AWSConnectorService2ImplBase;
import net.utoolity.atlassian.ifaws.model.AWSConnectorEntity;

public class AWSConnectorService2Impl
extends AWSConnectorService2ImplBase
implements AWSConnectorService2 {
    public AWSConnectorService2Impl(LicenseHelper licenseHelper, AWSConnectorPersistenceService awsConnectorPersistenceService, AWSSecurityTokenClientProxy tokenClientProxy, UserManager userManager, PluginConfiguration pluginConfiguration) {
        super(licenseHelper, awsConnectorPersistenceService, tokenClientProxy, userManager, pluginConfiguration);
    }

    @Override
    public List<AWSConnectorDTO2> getConnectors() throws LicenseException {
        return this.getConnectors(null);
    }

    @Override
    public List<AWSConnectorDTO2> getConnectors(AWSConnectorScope awsConnectorScope) throws LicenseException {
        this.licenseHelper.ensureValidLicense();
        UserKey userKey = this.findCurrentUserKey();
        AWSConnectorEntity[] matches = null != awsConnectorScope ? this.awsConnectorPersistenceService.findByScope(awsConnectorScope) : this.awsConnectorPersistenceService.findAll();
        ArrayList<AWSConnectorDTO2> result = new ArrayList<AWSConnectorDTO2>();
        for (AWSConnectorEntity awsConnector : matches) {
            if (!this.hasAccess(userKey, awsConnector, null)) continue;
            result.add(AWSConnectorService2Impl.createAWSConnectorDTO2(awsConnector));
        }
        return result;
    }

    @Override
    public AWSConnectorDTO2 getConnector(String connectorId) throws NotAuthorizedException, LicenseException {
        return this.getConnector(connectorId, null);
    }

    @Override
    public AWSConnectorDTO2 getConnector(String connectorId, AWSConnectorScope awsConnectorScope) throws NotAuthorizedException, LicenseException {
        this.licenseHelper.ensureValidLicense();
        AWSConnectorEntity awsConnector = this.awsConnectorPersistenceService.getById(connectorId);
        UserKey userKey = this.findCurrentUserKey();
        if (null == awsConnector) {
            return null;
        }
        if (!this.hasAccess(userKey, awsConnector, awsConnectorScope)) {
            throw new NotAuthorizedException("Requesting user is not authorized to access this Connector");
        }
        return AWSConnectorService2Impl.createAWSConnectorDTO2(awsConnector);
    }

    public static AWSConnectorDTO2 createAWSConnectorDTO2(AWSConnectorEntity awsConnector) {
        AWSConnectorDTO2 awsConnectorDTO2 = new AWSConnectorDTO2();
        awsConnectorDTO2.setId(awsConnector.getId());
        awsConnectorDTO2.setName(awsConnector.getName());
        awsConnectorDTO2.setType(awsConnector.getType());
        awsConnectorDTO2.setScope(null != awsConnector.getScope() ? awsConnector.getScope().name() : null);
        awsConnectorDTO2.setDurationSecondsMax(awsConnector.getDurationSecondsMax());
        if (null != awsConnector.getCloudProvider()) {
            awsConnectorDTO2.setPartition(awsConnector.getCloudProvider().getPartitionKey());
        }
        return awsConnectorDTO2;
    }
}

