/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.ao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import net.utoolity.atlassian.ifaws.ao.AWSConnector;
import net.utoolity.atlassian.ifaws.ao.AWSConnectorGroup;
import net.utoolity.atlassian.ifaws.ao.AWSConnectorPersistenceService;
import net.utoolity.atlassian.ifaws.ao.AWSConnectorPredicates;
import net.utoolity.atlassian.ifaws.api.AWSConnectorScope;
import net.utoolity.atlassian.ifaws.model.AWSConnectorEntity;
import net.utoolity.atlassian.ifaws.model.AWSConnectorEntityImpl;

public class AWSConnectorPersistenceServiceImpl
implements AWSConnectorPersistenceService {
    private final ActiveObjects ao;

    public AWSConnectorPersistenceServiceImpl(ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public AWSConnectorEntity getById(final String id) {
        AWSConnector aoEntity = (AWSConnector)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<AWSConnector>(){

            public AWSConnector doInTransaction() {
                return AWSConnectorPersistenceServiceImpl.this.getByIdOutsideTransaction(id);
            }
        });
        return this.createAWSConnectorOrNull(aoEntity);
    }

    private AWSConnector getByIdOutsideTransaction(String id) {
        return (AWSConnector)this.ao.get(AWSConnector.class, (Object)id);
    }

    @Override
    public AWSConnectorEntity getByV1Id(final int v1Id) {
        AWSConnector aoEntity = (AWSConnector)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<AWSConnector>(){

            public AWSConnector doInTransaction() {
                String whereClause = "V1_ID = ?";
                int param = v1Id;
                Query query = Query.select().where(whereClause, new Object[]{param});
                return ((AWSConnector[])AWSConnectorPersistenceServiceImpl.this.ao.find(AWSConnector.class, query))[0];
            }
        });
        return this.createAWSConnectorOrNull(aoEntity);
    }

    @Override
    public AWSConnectorEntity create(final Map<String, Object> params) {
        AWSConnector aoEntity = (AWSConnector)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<AWSConnector>(){

            public AWSConnector doInTransaction() {
                AWSConnector awsConnector = (AWSConnector)AWSConnectorPersistenceServiceImpl.this.ao.create(AWSConnector.class, params);
                return awsConnector;
            }
        });
        return this.createAWSConnectorOrNull(aoEntity);
    }

    @Override
    public AWSConnectorEntity save(AWSConnectorEntity awsConnector) {
        final AWSConnector originalEntity = awsConnector.getAWSConnectorEntity();
        AWSConnector updatedEntity = (AWSConnector)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<AWSConnector>(){

            public AWSConnector doInTransaction() {
                originalEntity.save();
                return AWSConnectorPersistenceServiceImpl.this.getByIdOutsideTransaction(originalEntity.getId());
            }
        });
        return this.createAWSConnectorOrNull(updatedEntity);
    }

    @Override
    public void delete(AWSConnectorEntity awsConnector) {
        final AWSConnector originalEntity = awsConnector.getAWSConnectorEntity();
        this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                AWSConnectorPersistenceServiceImpl.this.ao.delete((RawEntity[])originalEntity.getGroups());
                AWSConnectorPersistenceServiceImpl.this.ao.delete(new RawEntity[]{originalEntity});
                return null;
            }
        });
    }

    @Override
    public AWSConnectorEntity addGroup(AWSConnectorEntity awsConnector, final String name) {
        final AWSConnector originalEntity = awsConnector.getAWSConnectorEntity();
        AWSConnector updatedEntity = (AWSConnector)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<AWSConnector>(){

            public AWSConnector doInTransaction() {
                return AWSConnectorPersistenceServiceImpl.this.addGroupOutsideTransaction(originalEntity, name);
            }
        });
        return this.createAWSConnectorOrNull(updatedEntity);
    }

    private AWSConnector addGroupOutsideTransaction(AWSConnector awsConnector, String name) {
        for (AWSConnectorGroup group : awsConnector.getGroups()) {
            if (!group.getName().equalsIgnoreCase(name)) continue;
            return awsConnector;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("NAME", name);
        AWSConnectorGroup group = (AWSConnectorGroup)this.ao.create(AWSConnectorGroup.class, params);
        group.setAWSConnector(awsConnector);
        group.save();
        return this.getByIdOutsideTransaction(awsConnector.getId());
    }

    @Override
    public AWSConnectorEntity addGroups(AWSConnectorEntity awsConnector, final String[] groups) {
        final AWSConnector originalEntity = awsConnector.getAWSConnectorEntity();
        AWSConnector updatedEntity = (AWSConnector)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<AWSConnector>(){

            public AWSConnector doInTransaction() {
                for (String groupName : groups) {
                    AWSConnectorPersistenceServiceImpl.this.addGroupOutsideTransaction(originalEntity, groupName);
                }
                return AWSConnectorPersistenceServiceImpl.this.getByIdOutsideTransaction(originalEntity.getId());
            }
        });
        return this.createAWSConnectorOrNull(updatedEntity);
    }

    @Override
    public AWSConnectorEntity updateGroups(final AWSConnectorEntity awsConnector, final String[] groups) {
        final AWSConnector originalEntity = awsConnector.getAWSConnectorEntity();
        AWSConnector updatedEntity = (AWSConnector)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<AWSConnector>(){

            public AWSConnector doInTransaction() {
                ArrayList desiredGroups = Lists.newArrayList((Object[])groups);
                ArrayList existingGroups = Lists.newArrayList((Object[])awsConnector.getGroupNames());
                ArrayList groupsToAdd = Lists.newArrayList((Object[])groups);
                groupsToAdd.removeAll(existingGroups);
                for (String groupToAdd : groupsToAdd) {
                    AWSConnectorPersistenceServiceImpl.this.addGroupOutsideTransaction(originalEntity, groupToAdd);
                }
                ArrayList groupsToRemove = Lists.newArrayList((Object[])awsConnector.getGroupNames());
                groupsToRemove.removeAll(desiredGroups);
                for (String groupToRemove : groupsToRemove) {
                    AWSConnectorPersistenceServiceImpl.this.removeGroupByNameOutsideTransaction(originalEntity, groupToRemove);
                }
                return AWSConnectorPersistenceServiceImpl.this.getByIdOutsideTransaction(originalEntity.getId());
            }
        });
        return this.createAWSConnectorOrNull(updatedEntity);
    }

    @Override
    public AWSConnectorEntity removeGroup(AWSConnectorEntity awsConnector, final AWSConnectorGroup group) {
        final AWSConnector originalEntity = awsConnector.getAWSConnectorEntity();
        AWSConnector updatedEntity = (AWSConnector)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<AWSConnector>(){

            public AWSConnector doInTransaction() {
                return AWSConnectorPersistenceServiceImpl.this.removeGroupOutsideTransaction(originalEntity, group);
            }
        });
        return this.createAWSConnectorOrNull(updatedEntity);
    }

    private AWSConnector removeGroupOutsideTransaction(AWSConnector awsConnector, AWSConnectorGroup group) {
        if (!awsConnector.getId().equals(group.getAWSConnector().getId())) {
            throw new IllegalArgumentException("Group is not contained in given connector");
        }
        this.ao.delete(new RawEntity[]{group});
        return this.getByIdOutsideTransaction(awsConnector.getId());
    }

    @Override
    public AWSConnectorEntity removeAllGroups(AWSConnectorEntity awsConnector) {
        final AWSConnector originalEntity = awsConnector.getAWSConnectorEntity();
        AWSConnector updatedEntity = (AWSConnector)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<AWSConnector>(){

            public AWSConnector doInTransaction() {
                for (AWSConnectorGroup group : originalEntity.getGroups()) {
                    AWSConnectorPersistenceServiceImpl.this.removeGroupOutsideTransaction(originalEntity, group);
                }
                return AWSConnectorPersistenceServiceImpl.this.getByIdOutsideTransaction(originalEntity.getId());
            }
        });
        return this.createAWSConnectorOrNull(updatedEntity);
    }

    @Override
    public AWSConnectorEntity removeGroupByName(AWSConnectorEntity awsConnector, final String name) {
        final AWSConnector originalEntity = awsConnector.getAWSConnectorEntity();
        AWSConnector updatedEntity = (AWSConnector)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<AWSConnector>(){

            public AWSConnector doInTransaction() {
                return AWSConnectorPersistenceServiceImpl.this.removeGroupByNameOutsideTransaction(originalEntity, name);
            }
        });
        return this.createAWSConnectorOrNull(updatedEntity);
    }

    private AWSConnector removeGroupByNameOutsideTransaction(AWSConnector awsConnector, String name) {
        AWSConnectorGroup foundGroup = null;
        for (AWSConnectorGroup group : awsConnector.getGroups()) {
            if (!group.getName().equalsIgnoreCase(name)) continue;
            foundGroup = group;
            break;
        }
        if (null == foundGroup) {
            return awsConnector;
        }
        return this.removeGroupOutsideTransaction(awsConnector, foundGroup);
    }

    @Override
    public AWSConnectorEntity[] findAll() {
        AWSConnector[] aoEntities = (AWSConnector[])this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<AWSConnector[]>(){

            public AWSConnector[] doInTransaction() {
                String orderClause = "NAME ASC";
                Query query = Query.select().order(orderClause);
                return (AWSConnector[])AWSConnectorPersistenceServiceImpl.this.ao.find(AWSConnector.class, query);
            }
        });
        return this.createAWSConnectorArray(aoEntities);
    }

    @Override
    public AWSConnectorEntity[] findByExactNameCI(final String name) {
        return (AWSConnectorEntity[])this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<AWSConnectorEntity[]>(){

            public AWSConnectorEntity[] doInTransaction() {
                Predicate<AWSConnector> predicate = AWSConnectorPredicates.nameEqualsIgnoreCase(name);
                return AWSConnectorPersistenceServiceImpl.this.findByPredicate(predicate);
            }
        });
    }

    @Override
    public AWSConnectorEntity[] findByName(String substring, int limit) {
        return this.findByName(substring, limit, 0);
    }

    @Override
    public AWSConnectorEntity[] findByName(final String substring, final int limit, final int offset) {
        return (AWSConnectorEntity[])this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<AWSConnectorEntity[]>(){

            public AWSConnectorEntity[] doInTransaction() {
                Predicate<AWSConnector> predicate = AWSConnectorPredicates.nameContainsIgnoreCase(substring);
                AWSConnectorEntity[] allMatches = AWSConnectorPersistenceServiceImpl.this.findByPredicate(predicate);
                return AWSConnectorPersistenceServiceImpl.this.extractByLimitAndOffset(allMatches, limit, offset);
            }
        });
    }

    @Override
    public AWSConnectorEntity[] findByFuzzySearch(final String substring, final int limit) {
        return (AWSConnectorEntity[])this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<AWSConnectorEntity[]>(){

            public AWSConnectorEntity[] doInTransaction() {
                return AWSConnectorPersistenceServiceImpl.this.findByFuzzySearch(substring, limit, 0);
            }
        });
    }

    @Override
    public AWSConnectorEntity[] findByFuzzySearch(String substring, int limit, int offset) {
        Predicate<AWSConnector> predicate = AWSConnectorPredicates.connectorContainsIgnoreCase(substring);
        AWSConnectorEntity[] allMatches = this.findByPredicate(predicate);
        return this.extractByLimitAndOffset(allMatches, limit, offset);
    }

    @Override
    public AWSConnectorEntity[] findByGroups(final String[] groupNames) {
        return (AWSConnectorEntity[])this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<AWSConnectorEntity[]>(){

            public AWSConnectorEntity[] doInTransaction() {
                HashSet<AWSConnectorGroup> foundGroups = new HashSet<AWSConnectorGroup>();
                for (String groupName : groupNames) {
                    AWSConnectorGroup[] partialResult = AWSConnectorPersistenceServiceImpl.this.findByGroup(groupName);
                    foundGroups.addAll(Arrays.asList(partialResult));
                }
                HashSet<AWSConnectorEntityImpl> result = new HashSet<AWSConnectorEntityImpl>();
                for (AWSConnectorGroup group : foundGroups) {
                    result.add(new AWSConnectorEntityImpl(group.getAWSConnector()));
                }
                return result.toArray(new AWSConnectorEntity[result.size()]);
            }
        });
    }

    private AWSConnectorGroup[] findByGroup(String groupName) {
        return (AWSConnectorGroup[])this.ao.find(AWSConnectorGroup.class, "NAME = ?", new Object[]{groupName});
    }

    @Override
    public AWSConnectorEntity[] findByScope(final AWSConnectorScope scope) {
        AWSConnector[] aoEntities = (AWSConnector[])this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<AWSConnector[]>(){

            public AWSConnector[] doInTransaction() {
                String whereClause = "SCOPE= ?";
                String orderClause = "NAME ASC";
                Query query = Query.select().where(whereClause, new Object[]{scope.name()}).order(orderClause);
                return (AWSConnector[])AWSConnectorPersistenceServiceImpl.this.ao.find(AWSConnector.class, query);
            }
        });
        return this.createAWSConnectorArray(aoEntities);
    }

    @Override
    public AWSConnectorEntity[] findByPredicate(Predicate<AWSConnector> predicate) {
        Object[] allConnectorsArray = (AWSConnector[])this.ao.find(AWSConnector.class);
        ImmutableSet allConnectors = ImmutableSet.copyOf((Object[])allConnectorsArray);
        Comparator<AWSConnector> comparator = this.createAWSConnectorNameComparator();
        List sortedFiltered = Ordering.from(comparator).sortedCopy(Iterables.filter((Iterable)allConnectors, predicate));
        return this.createAWSConnectorArray(sortedFiltered);
    }

    private Comparator<AWSConnector> createAWSConnectorNameComparator() {
        Comparator<AWSConnector> comparator = new Comparator<AWSConnector>(){

            @Override
            public int compare(AWSConnector connector1, AWSConnector connector2) {
                String name1 = connector1.getName();
                String name2 = connector2.getName();
                return name1.compareToIgnoreCase(name2);
            }
        };
        return comparator;
    }

    @Override
    public Map<String, Object> createEmptyPropertyMap() {
        HashMap<String, Object> emptyMap = new HashMap<String, Object>();
        emptyMap.put("ID", null);
        emptyMap.put("NAME", "");
        emptyMap.put("TYPE", "");
        emptyMap.put("AWS_ACCOUNTID", null);
        emptyMap.put("ROLE_ARN", "");
        emptyMap.put("EXTERNAL_ID", "");
        emptyMap.put("IAM_POLICY", "");
        emptyMap.put("IAM_POLICY_ARNS", "");
        emptyMap.put("DURATION_SECONDS_MAX", null);
        emptyMap.put("GROUPS", new String[0]);
        emptyMap.put("SCOPE", null);
        emptyMap.put("V1_ID", null);
        return emptyMap;
    }

    @Override
    public Map<String, Object> toPropertyMap(AWSConnectorEntity awsConnector) {
        HashMap<String, Object> emptyMap = new HashMap<String, Object>();
        emptyMap.put("ID", awsConnector.getId());
        emptyMap.put("NAME", awsConnector.getName());
        emptyMap.put("TYPE", awsConnector.getType());
        emptyMap.put("AWS_ACCOUNTID", awsConnector.getAWSAccount());
        emptyMap.put("ROLE_ARN", awsConnector.getRoleArn());
        emptyMap.put("EXTERNAL_ID", awsConnector.getExternalId());
        emptyMap.put("IAM_POLICY", awsConnector.getIAMPolicy());
        emptyMap.put("IAM_POLICY_ARNS", awsConnector.getIAMPolicyArns());
        emptyMap.put("DURATION_SECONDS_MAX", awsConnector.getDurationSecondsMax());
        emptyMap.put("GROUPS", awsConnector.getGroupNames());
        emptyMap.put("SCOPE", awsConnector.getScope());
        emptyMap.put("V1_ID", awsConnector.getV1Id());
        return emptyMap;
    }

    private AWSConnectorEntity[] extractByLimitAndOffset(AWSConnectorEntity[] allMatches, int limit, int offset) {
        if (0 == offset) {
            if (allMatches.length <= limit) {
                return allMatches;
            }
            return Arrays.copyOfRange(allMatches, 0, limit);
        }
        if (allMatches.length >= offset) {
            int maxLimit = allMatches.length;
            int copyLimit = offset + limit;
            if (maxLimit < copyLimit) {
                copyLimit = maxLimit;
            }
            return Arrays.copyOfRange(allMatches, offset, copyLimit);
        }
        return new AWSConnectorEntity[0];
    }

    private AWSConnectorEntity createAWSConnectorOrNull(AWSConnector aoEntity) {
        if (null != aoEntity) {
            return new AWSConnectorEntityImpl(aoEntity);
        }
        return null;
    }

    private AWSConnectorEntity[] createAWSConnectorArray(AWSConnector[] aoEntities) {
        AWSConnectorEntity[] results = new AWSConnectorEntity[aoEntities.length];
        for (int i = 0; i < aoEntities.length; ++i) {
            results[i] = new AWSConnectorEntityImpl(aoEntities[i]);
        }
        return results;
    }

    private AWSConnectorEntity[] createAWSConnectorArray(List<AWSConnector> sortedFiltered) {
        AWSConnectorEntity[] results = new AWSConnectorEntity[sortedFiltered.size()];
        for (int i = 0; i < sortedFiltered.size(); ++i) {
            results[i] = new AWSConnectorEntityImpl(sortedFiltered.get(i));
        }
        return results;
    }
}

