/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.rest.common;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.atlassian.sal.api.message.I18nResolver;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import net.utoolity.atlassian.ifaws.rest.common.AmazonClientExceptionMapper;
import net.utoolity.atlassian.ifaws.rest.common.AmazonServiceExceptionMapper;
import net.utoolity.atlassian.ifaws.rest.common.ErrorResponseDTO;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class RuntimeExceptionMapper
implements ExceptionMapper<RuntimeException> {
    private static final Logger log = LoggerFactory.getLogger(RuntimeExceptionMapper.class);
    private I18nResolver i18n;

    public void setI18n(I18nResolver i18n) {
        this.i18n = i18n;
    }

    public Response toResponse(RuntimeException re) {
        if (re instanceof WebApplicationException) {
            WebApplicationException webEx = (WebApplicationException)re;
            if (webEx.getResponse().getStatus() == Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()) {
                log.error("Server Error in REST: " + webEx.getResponse().getStatus() + ": " + webEx.getResponse(), (Throwable)re);
            } else {
                log.debug("REST response: {}: {}", (Object)webEx.getResponse().getStatus(), (Object)webEx.getResponse());
            }
            return webEx.getResponse();
        }
        if (null != re.getCause() && re.getCause() instanceof AmazonServiceException) {
            AmazonServiceExceptionMapper mapper = new AmazonServiceExceptionMapper();
            return mapper.toResponse((AmazonServiceException)re.getCause());
        }
        if (null != re.getCause() && re.getCause() instanceof AmazonClientException) {
            AmazonClientExceptionMapper mapper = new AmazonClientExceptionMapper();
            return mapper.toResponse((AmazonClientException)re.getCause());
        }
        ErrorResponseDTO responseEntity = new ErrorResponseDTO((Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, re.getClass().getSimpleName(), re.getMessage());
        if (null != re.getStackTrace()) {
            String fullStackTrace = ExceptionUtils.getStackTrace((Throwable)re);
            responseEntity.addErrorMessage(fullStackTrace);
        }
        return Response.status((Response.StatusType)responseEntity.getStatus()).entity((Object)responseEntity).build();
    }
}

