/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.rest.common;

import com.google.common.collect.Iterables;
import javax.annotation.Nonnull;
import net.utoolity.atlassian.ifaws.rest.common.DTOCollection;

public class DTOCollectionImpl<T>
implements DTOCollection<T> {
    private final Iterable<T> values;
    private volatile Integer size;

    public DTOCollectionImpl(Iterable<T> values) {
        this.values = values;
    }

    public DTOCollectionImpl(Iterable<T> values, int size) {
        this(values);
        this.size = size;
    }

    @Override
    @Nonnull
    public Iterable<T> getValues() {
        return this.values;
    }

    @Override
    public int getSize() {
        if (this.size == null) {
            this.inspectValues();
        }
        return this.size;
    }

    private synchronized void inspectValues() {
        this.size = Iterables.size(this.values);
    }
}

