/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.aws;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.services.ecr.AmazonECR;
import com.amazonaws.services.ecr.AmazonECRClient;
import com.amazonaws.services.ecr.model.AuthorizationData;
import com.amazonaws.services.ecr.model.GetAuthorizationTokenRequest;
import com.amazonaws.services.ecr.model.GetAuthorizationTokenResult;
import java.util.ArrayList;
import java.util.List;
import net.utoolity.atlassian.dry.AmazonWebServiceClientFactory;
import net.utoolity.atlassian.dry.ParameterValidationException;
import net.utoolity.atlassian.ifaws.api.ECRCredentialsDTO;
import org.apache.commons.lang3.StringUtils;

public final class ECR {
    private static final String REGISTRY_ID_PATTERN = "[0-9]{12}";

    private ECR() {
    }

    public static boolean isValidECRRegistryId(String registryId) {
        return null != registryId && registryId.matches(REGISTRY_ID_PATTERN);
    }

    public static List<ECRCredentialsDTO> getECRCredentials(AWSCredentialsProvider awsCredentialsProvider, List<String> registryIds, String regionName, ClientConfiguration clientConfiguration) {
        return ECR.getECRCredentials(awsCredentialsProvider.getCredentials(), registryIds, regionName, clientConfiguration);
    }

    public static List<ECRCredentialsDTO> getECRCredentials(AWSCredentials awsCredentials, List<String> registryIds, String regionName) {
        return ECR.getECRCredentials(awsCredentials, registryIds, regionName, null);
    }

    public static List<ECRCredentialsDTO> getECRCredentials(AWSCredentials awsCredentials, List<String> registryIds, String regionName, ClientConfiguration clientConfiguration) {
        ArrayList<ECRCredentialsDTO> ecrCredentialsDTOList = new ArrayList<ECRCredentialsDTO>();
        AmazonECR ecr = null != clientConfiguration ? (AmazonECR)new AmazonWebServiceClientFactory().createClient(AmazonECRClient.class, awsCredentials, clientConfiguration) : (AmazonECR)new AmazonWebServiceClientFactory().createClient(AmazonECRClient.class, awsCredentials);
        if (StringUtils.isNotBlank((CharSequence)regionName)) {
            Region region = RegionUtils.getRegion((String)regionName);
            if (null != region) {
                ecr.setRegion(region);
            } else {
                throw new ParameterValidationException("Unknown region name: " + regionName);
            }
        }
        GetAuthorizationTokenRequest getAuthorizationTokenRequest = new GetAuthorizationTokenRequest();
        if (registryIds.size() > 0) {
            getAuthorizationTokenRequest.setRegistryIds(registryIds);
        }
        GetAuthorizationTokenResult getAuthorizationTokenResult = ecr.getAuthorizationToken(getAuthorizationTokenRequest);
        List authorizationDataList = getAuthorizationTokenResult.getAuthorizationData();
        for (AuthorizationData authorizationData : authorizationDataList) {
            ECRCredentialsDTO ecrCredentialsDTO = new ECRCredentialsDTO(authorizationData);
            ecrCredentialsDTOList.add(ecrCredentialsDTO);
        }
        return ecrCredentialsDTOList;
    }
}

