/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.aws;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.codeartifact.AWSCodeArtifact;
import com.amazonaws.services.codeartifact.AWSCodeArtifactClient;
import com.amazonaws.services.codeartifact.AWSCodeArtifactClientBuilder;
import com.amazonaws.services.codeartifact.model.GetAuthorizationTokenRequest;
import com.amazonaws.services.codeartifact.model.GetAuthorizationTokenResult;
import net.utoolity.atlassian.ifaws.api.CodeArtifactCredentialsDTO;
import org.apache.commons.lang3.StringUtils;

public final class CodeArtifact {
    private static final String DOMAIN_PATTERN = "[a-z][a-z0-9\\-]{0,48}[a-z0-9]";
    private static final String DOMAIN_OWNER_PATTERN = "[0-9]{12}";
    private static final int DURATION_SECONDS_MIN = 900;
    private static final int DURATION_SECONDS_MAX = 43200;

    private CodeArtifact() {
    }

    public static CodeArtifactCredentialsDTO getCodeArtifactCredentials(AWSCredentialsProvider awsCredentials, String domain, String domainOwner, Integer durationSeconds, String regionName, ClientConfiguration clientConfiguration) {
        AWSCodeArtifactClientBuilder codeArtifactClientBuilder = (AWSCodeArtifactClientBuilder)AWSCodeArtifactClient.builder().withCredentials(awsCredentials);
        if (null != clientConfiguration) {
            codeArtifactClientBuilder.setClientConfiguration(clientConfiguration);
        }
        if (null != regionName) {
            codeArtifactClientBuilder.setRegion(regionName);
        }
        AWSCodeArtifact codeArtifact = (AWSCodeArtifact)codeArtifactClientBuilder.build();
        GetAuthorizationTokenRequest getAuthorizationTokenRequest = new GetAuthorizationTokenRequest().withDomain(domain);
        if (StringUtils.isNotBlank((CharSequence)domainOwner)) {
            getAuthorizationTokenRequest.setDomainOwner(domainOwner);
        }
        if (null != durationSeconds) {
            getAuthorizationTokenRequest.setDurationSeconds(Long.valueOf(durationSeconds.longValue()));
        }
        GetAuthorizationTokenResult getAuthorizationTokenResult = codeArtifact.getAuthorizationToken(getAuthorizationTokenRequest);
        CodeArtifactCredentialsDTO codeArtifactCredentialsDTO = new CodeArtifactCredentialsDTO(getAuthorizationTokenResult);
        return codeArtifactCredentialsDTO;
    }

    public static boolean isValidDomain(String domain) {
        return null != domain && domain.matches(DOMAIN_PATTERN);
    }

    public static boolean isValidDomainOwner(String domainOwner) {
        return null != domainOwner && domainOwner.matches(DOMAIN_OWNER_PATTERN);
    }

    public static boolean isValidDurationSeconds(int durationSeconds) {
        if (0 == durationSeconds) {
            return true;
        }
        return durationSeconds >= 900 && durationSeconds <= 43200;
    }
}

