/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.api;

import com.amazonaws.services.codeartifact.model.GetAuthorizationTokenResult;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.ISODateTimeFormat;

@XmlRootElement(name="credentials")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CodeArtifactCredentialsDTO {
    @XmlElement(name="authorizationToken")
    private final String authorizationToken;
    @XmlElement(name="expirationDate")
    private final String expirationDate;

    public CodeArtifactCredentialsDTO(GetAuthorizationTokenResult getAuthorizationTokenResult) {
        this.authorizationToken = getAuthorizationTokenResult.getAuthorizationToken();
        this.expirationDate = this.formatISODateTime(getAuthorizationTokenResult.getExpiration());
    }

    private String formatISODateTime(Date date) {
        return new DateTime((Object)date).toString(ISODateTimeFormat.basicDateTimeNoMillis().withZone(DateTimeZone.UTC));
    }

    public String getAuthorizationToken() {
        return this.authorizationToken;
    }

    public String getExpirationDate() {
        return this.expirationDate;
    }
}

