/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.ao;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.EC2ContainerCredentialsProviderWrapper;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.GetCallerIdentityRequest;
import com.amazonaws.services.securitytoken.model.GetCallerIdentityResult;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.utoolity.atlassian.dry.PluginInfo;
import net.utoolity.atlassian.dry.StaticComponentAccessor;
import net.utoolity.atlassian.ifaws.PluginConfiguration;
import net.utoolity.atlassian.ifaws.ao.AWSAccountPersistenceService;
import net.utoolity.atlassian.ifaws.ao.DefaultCloudProvider;
import net.utoolity.atlassian.ifaws.model.AWSAccountEntity;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IAMRoleForEC2AndECSService {
    private static final String IAM_ROLE_FOR_EC2_AND_ECS_ACCOUNT_NAME = "[IAM role for EC2/ECS]";
    private static final String IAM_ROLE_FOR_EC2_AND_ECS_ENTRY_PLACEHOLDER = "ASIAIAMROLEFOREC2ECS";
    private static final Logger log = LoggerFactory.getLogger(IAMRoleForEC2AndECSService.class);
    public static final Pattern PARTITION_KEY_EXTRACTION_PATTERN = Pattern.compile("arn:(.*?):.*");
    private final PluginConfiguration pluginConfiguration;
    private final AWSAccountPersistenceService awsAccountPersistenceService;
    public static final String IAM_ROLE_FOR_EC2_ACCOUNT_ID_KEY = PluginInfo.PLUGIN_SETTINGS_NAMESPACE.concat(".ec2AccountId");

    public IAMRoleForEC2AndECSService(PluginConfiguration pluginConfiguration, AWSAccountPersistenceService awsAccountPersistenceService) {
        this.pluginConfiguration = pluginConfiguration;
        this.awsAccountPersistenceService = awsAccountPersistenceService;
    }

    public void createEC2PlaceholderAccount() {
        HashMap<String, Object> defaultParams = new HashMap<String, Object>();
        defaultParams.put("NAME", IAM_ROLE_FOR_EC2_AND_ECS_ACCOUNT_NAME);
        defaultParams.put("AWS_ACCESS_KEY_ID", IAM_ROLE_FOR_EC2_AND_ECS_ENTRY_PLACEHOLDER);
        defaultParams.put("AWS_SECRET_KEY", IAM_ROLE_FOR_EC2_AND_ECS_ENTRY_PLACEHOLDER);
        defaultParams.put("CLOUD_PROVIDER_KEY", this.determineEC2ECSCloudProviderKey());
        AWSAccountEntity account = this.awsAccountPersistenceService.create(defaultParams);
        this.pluginConfiguration.writeStringSetting(IAM_ROLE_FOR_EC2_ACCOUNT_ID_KEY, account.getId());
    }

    public void deleteEC2PlaceholderAccount() {
        if (this.ec2PlaceholderAccountExists()) {
            AWSAccountEntity account = this.getEC2PlaceholderAccount();
            if (this.isEC2PlaceholderAccountInUse(account)) {
                throw new RuntimeException(String.format("Account %s is still used by connectors and can not be deleted", account.getName()));
            }
            this.awsAccountPersistenceService.delete(account);
        }
    }

    public boolean canDeleteEC2PlaceholderAccount() {
        AWSAccountEntity account = this.getEC2PlaceholderAccount();
        if (null == account) {
            return true;
        }
        return !this.isEC2PlaceholderAccountInUse(account);
    }

    private boolean isEC2PlaceholderAccountInUse(AWSAccountEntity account) {
        return 1 <= account.getAWSConnectors().length;
    }

    public static boolean isEC2PlaceholderAccount(AWSAccountEntity awsAccountEntity) {
        PluginConfiguration pluginConfiguration = StaticComponentAccessor.getPluginConfiguration();
        String placeholderAccountID = pluginConfiguration.readStringSetting(IAM_ROLE_FOR_EC2_ACCOUNT_ID_KEY);
        return null != placeholderAccountID && placeholderAccountID.equals(awsAccountEntity.getId());
    }

    public boolean isEC2PlaceholderAccountID(String accountID) {
        String placeholderAccountID = this.pluginConfiguration.readStringSetting(IAM_ROLE_FOR_EC2_ACCOUNT_ID_KEY);
        return null != placeholderAccountID && placeholderAccountID.equals(accountID);
    }

    public String getEC2PlaceholderAccountID() {
        return this.pluginConfiguration.readStringSetting(IAM_ROLE_FOR_EC2_ACCOUNT_ID_KEY);
    }

    public boolean isIAMRoleForEC2OrECSEnabled() {
        return this.ec2PlaceholderAccountExists();
    }

    public void enableIAMRoleForEC2CredentialsProvider() {
        this.ensureEC2PlaceholderAccountEntry();
    }

    public void disableIAMRoleForEC2CredentialsProvider() {
        this.deleteEC2PlaceholderAccount();
    }

    public static boolean isIAMRoleForEC2OrECSSupported() {
        if (null != System.getenv("UTOOLITY_IAM_ROLE_FOR_EC2_AND_ECS_AVAILABILITY_OVERRIDE")) {
            return true;
        }
        try {
            AWSCredentialsProvider credentialsProvider = IAMRoleForEC2AndECSService.getRefreshedEC2ContainerCredentialsProviderWrapper();
            AWSCredentials credentials = credentialsProvider.getCredentials();
            return credentials != null;
        }
        catch (Exception e) {
            log.info("Can not retrieve AWSCredentialsProvider from EC2ContainerCredentialsProviderWrapper, assuming not available", (Throwable)e);
            return false;
        }
    }

    public static AWSCredentialsProvider getRefreshedEC2ContainerCredentialsProviderWrapper() {
        EC2ContainerCredentialsProviderWrapper credentialsProvider = new EC2ContainerCredentialsProviderWrapper();
        credentialsProvider.refresh();
        return credentialsProvider;
    }

    private void ensureEC2PlaceholderAccountEntry() {
        if (!this.ec2PlaceholderAccountExists()) {
            this.createEC2PlaceholderAccount();
        }
    }

    private boolean ec2PlaceholderAccountExists() {
        return null != this.getEC2PlaceholderAccount();
    }

    private AWSAccountEntity getEC2PlaceholderAccount() {
        String accountID = this.getEC2PlaceholderAccountId();
        if (StringUtils.isNotBlank((CharSequence)accountID)) {
            return this.awsAccountPersistenceService.getById(accountID);
        }
        return null;
    }

    private String getEC2PlaceholderAccountId() {
        return this.pluginConfiguration.readStringSetting(IAM_ROLE_FOR_EC2_ACCOUNT_ID_KEY);
    }

    private String determineEC2ECSCloudProviderKey() {
        AWSCredentialsProvider credentialsProvider = IAMRoleForEC2AndECSService.getRefreshedEC2ContainerCredentialsProviderWrapper();
        AWSSecurityTokenService sts = (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClient.builder().withCredentials(credentialsProvider)).build();
        GetCallerIdentityRequest getCallerIdentityRequest = new GetCallerIdentityRequest();
        String arn = null;
        try {
            GetCallerIdentityResult response = sts.getCallerIdentity(getCallerIdentityRequest);
            arn = response.getArn();
        }
        catch (Exception e) {
            log.error("Failed to get caller identity for partition determination:", (Throwable)e);
        }
        String partitionKey = this.extractPartitionKeyFromKeyARN(arn);
        return StringUtils.isNotBlank((CharSequence)partitionKey) ? partitionKey : DefaultCloudProvider.AWS.getPartitionKey();
    }

    @VisibleForTesting
    public String extractPartitionKeyFromKeyARN(String arn) {
        String partitionKey = null;
        try {
            Matcher matcher = PARTITION_KEY_EXTRACTION_PATTERN.matcher(arn);
            matcher.find();
            partitionKey = matcher.group(1);
        }
        catch (Exception e) {
            log.error("Failed to extract partition key from ARN: " + arn);
        }
        return StringUtils.isNotBlank((CharSequence)partitionKey) ? partitionKey : null;
    }
}

