/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.dry;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestriction;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.utoolity.atlassian.dry.GroupAccessor;

public class GroupAccessorImpl
implements GroupAccessor {
    private final CrowdService crowdService;
    private final int MAX_GROUPS_TO_FETCH_AT_ONCE = 1000;

    public GroupAccessorImpl(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    @Override
    public List<String> getGroups() {
        ArrayList<String> groups = new ArrayList<String>();
        int startIndex = 0;
        boolean allFetched = false;
        while (!allFetched) {
            int fetchedCount = 0;
            EntityQuery<String> query = this.createQuery(startIndex);
            Iterable availableGroups = this.crowdService.search(query);
            for (String availableGroup : availableGroups) {
                groups.add(availableGroup);
                ++fetchedCount;
            }
            startIndex += 1000;
            allFetched = fetchedCount < 1000;
        }
        return groups;
    }

    private EntityQuery<String> createQuery(int startIndex) {
        NullRestriction searchRestriction = NullRestrictionImpl.INSTANCE;
        EntityQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group(), (SearchRestriction)searchRestriction, (int)startIndex, (int)1000);
        return query;
    }

    @Override
    public Map<String, String> getGroupsMapKeyedByName() {
        HashMap<String, String> groups = new HashMap<String, String>();
        int startIndex = 0;
        boolean allFetched = false;
        while (!allFetched) {
            int fetchedCount = 0;
            EntityQuery<Group> query = this.createQueryForGroup(startIndex);
            Iterable availableGroups = this.crowdService.search(query);
            for (Group availableGroup : availableGroups) {
                groups.put(availableGroup.getName(), String.valueOf(availableGroup.hashCode()));
                ++fetchedCount;
            }
            startIndex += 1000;
            allFetched = fetchedCount < 1000;
        }
        return groups;
    }

    @Override
    public Map<String, String> getGroupsMapKeyedByNameContainingString(String filter) {
        HashMap<String, String> groups = new HashMap<String, String>();
        int startIndex = 0;
        boolean allFetched = false;
        while (!allFetched) {
            int fetchedCount = 0;
            EntityQuery<Group> query = this.createQueryForGroupContainingString(startIndex, filter);
            Iterable availableGroups = this.crowdService.search(query);
            for (Group availableGroup : availableGroups) {
                groups.put(availableGroup.getName(), String.valueOf(availableGroup.hashCode()));
                ++fetchedCount;
            }
            startIndex += 1000;
            allFetched = fetchedCount < 1000;
        }
        return groups;
    }

    @Override
    public Map<String, String> getGroupsMapKeyedByHashCode() {
        HashMap<String, String> groups = new HashMap<String, String>();
        int startIndex = 0;
        boolean allFetched = false;
        while (!allFetched) {
            int fetchedCount = 0;
            EntityQuery<Group> query = this.createQueryForGroup(startIndex);
            Iterable availableGroups = this.crowdService.search(query);
            for (Group availableGroup : availableGroups) {
                groups.put(String.valueOf(availableGroup.hashCode()), availableGroup.getName());
                ++fetchedCount;
            }
            startIndex += 1000;
            allFetched = fetchedCount < 1000;
        }
        return groups;
    }

    private EntityQuery<Group> createQueryForGroup(int startIndex) {
        NullRestriction searchRestriction = NullRestrictionImpl.INSTANCE;
        EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group(), (SearchRestriction)searchRestriction, (int)startIndex, (int)1000);
        return query;
    }

    private EntityQuery<Group> createQueryForGroupContainingString(int startIndex, String containingString) {
        EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).containing((Object)containingString)).startingAt(startIndex).returningAtMost(1000);
        return query;
    }
}

