/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.bamboo.ifaws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient;
import com.amazonaws.util.EC2MetadataUtils;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.CommonTaskType;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskState;
import com.atlassian.bamboo.utils.i18n.I18nBean;
import com.atlassian.bamboo.utils.i18n.I18nBeanFactory;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.VariableContext;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutor;
import java.util.Map;
import net.utoolity.atlassian.bamboo.ifaws.BaseTaskConfigurator;
import net.utoolity.atlassian.bamboo.ifaws.VariableScope;
import net.utoolity.atlassian.dry.AWSStaticSessionCredentialsProvider;
import net.utoolity.atlassian.dry.AmazonWebServiceClientFactory;
import net.utoolity.atlassian.ifaws.ao.DefaultCloudProvider;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTask
implements CommonTaskType {
    private static final String BAMBOO_AGENT_ID_VARIABLE = "${bamboo.agentId}";
    private static final Logger log = LoggerFactory.getLogger(BaseTask.class);
    private static final int DEFAULT_MAX_ERROR_RETRY = 7;
    private static final String MAX_ERROR_RETRY_VARIABLE_KEY = "custom.aws.maxErrorRetry";
    private static final int DEFAULT_ROLE_SESSION_DURATION_SECONDS = 3600;
    protected static final String VARIABLE_PREFIX_BAMBOO = "bamboo.";
    protected final CustomVariableContext customVariableContext;
    protected final I18nBeanFactory i18nBeanFactory;
    protected int maxErrorRetry = 7;
    private VariableScope variableScope = BaseTaskConfigurator.VARIABLE_SCOPE_DEFAULT;
    private String variableNamespace = "custom.aws";
    private VariableContext variableContext = null;

    public BaseTask(CustomVariableContext customVariableContext, I18nBeanFactory i18nBeanFactory) {
        this.customVariableContext = customVariableContext;
        this.i18nBeanFactory = i18nBeanFactory;
    }

    protected final I18nBean getI18nBean() {
        return this.i18nBeanFactory.getI18nBean();
    }

    public TaskResult execute(@NotNull CommonTaskContext commonTaskContext) throws TaskException {
        TaskResultBuilder taskResultBuilder = TaskResultBuilder.newBuilder((CommonTaskContext)commonTaskContext);
        ConfigurationMap configurationMap = commonTaskContext.getConfigurationMap();
        BuildLogger buildLogger = commonTaskContext.getBuildLogger();
        String validLicenseMarker = (String)commonTaskContext.getRuntimeTaskContext().get("isValidLicense");
        if (validLicenseMarker.equals("false")) {
            String licenseErrormessage = (String)commonTaskContext.getRuntimeTaskContext().get("licenseErrorMessage");
            buildLogger.addErrorLogEntry("License error for 'Identity Federation for AWS' plugin: " + licenseErrormessage);
            taskResultBuilder.failedWithError();
            return taskResultBuilder.build();
        }
        String pluginVersionOnServer = (String)commonTaskContext.getRuntimeTaskContext().get("pluginVersion");
        log.debug("App version on server: " + pluginVersionOnServer);
        String pluginVersionOnAgent = BaseTask.class.getPackage().getImplementationVersion();
        log.debug("App version on agent: " + pluginVersionOnAgent);
        if (null != pluginVersionOnServer && !pluginVersionOnServer.equals(pluginVersionOnAgent)) {
            String pluginVersionErrorMessage = "App version mismatch: agent reports '%s', server reports '%s'";
            buildLogger.addErrorLogEntry(String.format(pluginVersionErrorMessage, pluginVersionOnAgent, pluginVersionOnServer));
            taskResultBuilder.failedWithError();
            return taskResultBuilder.build();
        }
        this.initializeAWSInteractionParams(commonTaskContext, buildLogger);
        this.initializeVariablesParams(commonTaskContext, buildLogger);
        log.debug("PluginVersionOnSave was: {}", configurationMap.get((Object)"pluginVersionOnSave"));
        log.debug("PluginConfigVersionOnSave was: {}", configurationMap.get((Object)"pluginConfigVersionOnSave"));
        AWSCredentialsProvider awsCredentialsProvider = this.createCredentialsProvider(commonTaskContext, configurationMap, buildLogger, taskResultBuilder);
        DefaultCloudProvider cloudProvider = this.createCloudProvider(commonTaskContext, configurationMap, buildLogger, taskResultBuilder);
        if (TaskState.ERROR == taskResultBuilder.getTaskState()) {
            return taskResultBuilder.build();
        }
        ClientConfiguration clientConfiguration = this.createDefaultClientConfiguration();
        return this.execute(taskResultBuilder, configurationMap, buildLogger, commonTaskContext, awsCredentialsProvider, cloudProvider, clientConfiguration);
    }

    private ClientConfiguration createDefaultClientConfiguration() {
        return new ClientConfiguration().withMaxErrorRetry(this.maxErrorRetry);
    }

    protected abstract TaskResult execute(TaskResultBuilder var1, ConfigurationMap var2, BuildLogger var3, CommonTaskContext var4, AWSCredentialsProvider var5, DefaultCloudProvider var6, ClientConfiguration var7) throws TaskException;

    private AWSCredentialsProvider createCredentialsProvider(CommonTaskContext commonTaskContext, ConfigurationMap configurationMap, BuildLogger buildLogger, TaskResultBuilder taskResultBuilder) {
        String awsCredentialsSource = (String)configurationMap.get((Object)"awsCredentialsSource");
        if (null == awsCredentialsSource) {
            // empty if block
        }
        if (awsCredentialsSource.equals("IFAWS_CONNECTOR")) {
            return this.createIFAWSCredentialsProvider(commonTaskContext, buildLogger, taskResultBuilder);
        }
        if (awsCredentialsSource.equals("IAM_ROLE_AGENTS")) {
            return this.createIamRoleAgentsCredentialsProvider(commonTaskContext, buildLogger, taskResultBuilder);
        }
        throw new RuntimeException("Unknown AWS Credentials Source: " + awsCredentialsSource);
    }

    private AWSCredentialsProvider createIFAWSCredentialsProvider(CommonTaskContext commonTaskContext, BuildLogger buildLogger, TaskResultBuilder taskResultBuilder) {
        ConfigurationMap configurationMap = commonTaskContext.getConfigurationMap();
        String awsConnectorId = (String)configurationMap.get((Object)"awsConnectorId");
        if ("AWS_CONNECTOR_VARIABLE_KEY".equals(awsConnectorId)) {
            buildLogger.addBuildLogEntry("Using session credentials provided by Identity Federation for AWS app (connector variable: " + (String)configurationMap.get((Object)"awsConnectorIdVariable") + ").");
        } else {
            buildLogger.addBuildLogEntry("Using session credentials provided by Identity Federation for AWS app (connector ID: " + awsConnectorId + ").");
        }
        AWSStaticSessionCredentialsProvider credentialsProvider = null;
        Map runtimeTaskContext = commonTaskContext.getRuntimeTaskContext();
        boolean isConnectorServiceAvailable = Boolean.parseBoolean((String)runtimeTaskContext.get("isConnectorServiceAvailable"));
        if (isConnectorServiceAvailable) {
            if (null == runtimeTaskContext.get("credentialsError")) {
                String sessionToken;
                String secretKey;
                String accessKeyId = (String)runtimeTaskContext.get("accessKeyId");
                String secretKeyDecrypted = secretKey = (String)runtimeTaskContext.get("secretKey");
                String sessionTokenDecrypted = sessionToken = (String)runtimeTaskContext.get("sessionToken");
                BasicSessionCredentials sessionCredentials = new BasicSessionCredentials(accessKeyId, secretKeyDecrypted, sessionTokenDecrypted);
                credentialsProvider = new AWSStaticSessionCredentialsProvider((AWSSessionCredentials)sessionCredentials);
            } else {
                buildLogger.addErrorLogEntry("Failed to retrieve temporary AWS credentials: " + (String)runtimeTaskContext.get("credentialsError"));
                taskResultBuilder.failedWithError();
            }
        } else {
            buildLogger.addErrorLogEntry("Failed to retrieve temporary AWS credentials: AWSConnectorService is not available.");
            taskResultBuilder.failedWithError();
        }
        return credentialsProvider;
    }

    private AWSCredentialsProvider createIamRoleAgentsCredentialsProvider(CommonTaskContext commonTaskContext, BuildLogger buildLogger, TaskResultBuilder taskResultBuilder) {
        ConfigurationMap configurationMap = commonTaskContext.getConfigurationMap();
        InstanceProfileCredentialsProvider credentialsProvider = null;
        String awsIamRoleAgentsRoleArn = (String)configurationMap.get((Object)"awsIamRoleAgentsArn");
        boolean useRoleArn = StringUtils.isNotBlank((CharSequence)awsIamRoleAgentsRoleArn);
        boolean refreshCredentialsAsync = false;
        InstanceProfileCredentialsProvider instanceProfileCredentialsProvider = new InstanceProfileCredentialsProvider(refreshCredentialsAsync);
        try {
            if (useRoleArn) {
                String roleSessionName = this.getRoleSessionName(commonTaskContext);
                buildLogger.addBuildLogEntry("Using assume role session credentials provided by IAM Role EC2 (Agent), with role session name: " + roleSessionName);
                ClientConfiguration clientConfiguration = this.createDefaultClientConfiguration();
                AmazonWebServiceClientFactory clientFactory = new AmazonWebServiceClientFactory();
                AWSSecurityTokenService sts = (AWSSecurityTokenService)clientFactory.createClient(AWSSecurityTokenServiceClient.class, (AWSCredentialsProvider)instanceProfileCredentialsProvider, clientConfiguration);
                STSAssumeRoleSessionCredentialsProvider.Builder builder = new STSAssumeRoleSessionCredentialsProvider.Builder(awsIamRoleAgentsRoleArn, roleSessionName).withStsClient(sts).withRoleSessionDurationSeconds(3600);
                STSAssumeRoleSessionCredentialsProvider stsAssumeRoleSessionCredentialsProvider = builder.build();
                credentialsProvider = stsAssumeRoleSessionCredentialsProvider;
            } else {
                buildLogger.addBuildLogEntry("Using session credentials provided by IAM Role EC2 (Agent).");
                credentialsProvider = instanceProfileCredentialsProvider;
            }
        }
        catch (AmazonClientException ace) {
            buildLogger.addErrorLogEntry("Failed to retrieve session credentials by IAM Role for EC2.", (Throwable)ace);
            taskResultBuilder.failedWithError();
        }
        return credentialsProvider;
    }

    private DefaultCloudProvider createCloudProvider(CommonTaskContext commonTaskContext, ConfigurationMap configurationMap, BuildLogger buildLogger, TaskResultBuilder taskResultBuilder) {
        String awsCredentialsSource = (String)configurationMap.get((Object)"awsCredentialsSource");
        if (null == awsCredentialsSource) {
            throw new RuntimeException("Missing AWS Credentials Source: " + awsCredentialsSource);
        }
        if (awsCredentialsSource.equals("IFAWS_CONNECTOR")) {
            return this.createIFAWSCloudProvider(commonTaskContext, buildLogger, taskResultBuilder);
        }
        if (awsCredentialsSource.equals("IAM_ROLE_AGENTS")) {
            return this.createIamRoleAgentsCloudProvider(commonTaskContext, buildLogger, taskResultBuilder);
        }
        throw new RuntimeException("Unknown AWS Credentials Source: " + awsCredentialsSource);
    }

    private DefaultCloudProvider createIFAWSCloudProvider(CommonTaskContext commonTaskContext, BuildLogger buildLogger, TaskResultBuilder taskResultBuilder) {
        DefaultCloudProvider cloudProvider = null;
        Map runtimeTaskContext = commonTaskContext.getRuntimeTaskContext();
        boolean isConnectorServiceAvailable = Boolean.parseBoolean((String)runtimeTaskContext.get("isConnectorServiceAvailable"));
        if (isConnectorServiceAvailable) {
            if (null == runtimeTaskContext.get("credentialsError")) {
                String partitionKey = (String)runtimeTaskContext.get("partitionKey");
                cloudProvider = DefaultCloudProvider.getByPartitionKey(partitionKey);
            } else {
                buildLogger.addErrorLogEntry("Failed to retrieve partition key: " + (String)runtimeTaskContext.get("credentialsError"));
                taskResultBuilder.failedWithError();
            }
        } else {
            buildLogger.addErrorLogEntry("Failed to retrieve partition key: AWSConnectorService is not available.");
            taskResultBuilder.failedWithError();
        }
        return cloudProvider;
    }

    private DefaultCloudProvider createIamRoleAgentsCloudProvider(CommonTaskContext commonTaskContext, BuildLogger buildLogger, TaskResultBuilder taskResultBuilder) {
        DefaultCloudProvider cloudProvider = null;
        log.debug("Trying to retrieve partition key from EC2 metadata ...");
        String partitionKey = EC2MetadataUtils.getData((String)"/latest/meta-data/services/partition");
        log.debug("... got partition key: " + partitionKey);
        if (null != partitionKey) {
            try {
                cloudProvider = DefaultCloudProvider.getByPartitionKey(partitionKey);
            }
            catch (Exception e) {
                buildLogger.addErrorLogEntry("Failed to map instance partition key to cloudProvider: " + partitionKey);
            }
        } else {
            buildLogger.addErrorLogEntry("Failed to retrieve partition key from instance metadata");
        }
        if (null == cloudProvider) {
            buildLogger.addBuildLogEntry("Could not determine explicit instance partition, using default 'aws' instead");
            cloudProvider = DefaultCloudProvider.AWS;
        }
        return cloudProvider;
    }

    private String getRoleSessionName(CommonTaskContext commonTaskContext) {
        return this.getAgentId(commonTaskContext) + "@" + this.getInstanceId();
    }

    private String getInstanceId() {
        String sessionName = "unknownInstanceId";
        String instanceId = EC2MetadataUtils.getInstanceId();
        log.debug("Found instanceId from matadata: " + instanceId);
        if (StringUtils.isNotBlank((CharSequence)instanceId)) {
            sessionName = instanceId;
        }
        return sessionName;
    }

    private String getAgentId(CommonTaskContext commonTaskContext) {
        String agentId = "unknownAgent";
        VariableSubstitutor variableSubstitutor = this.createVariableSubstitutor(commonTaskContext);
        try {
            String replacedAgentId = variableSubstitutor.substituteString(BAMBOO_AGENT_ID_VARIABLE);
            log.debug("Replaced agentId from variable: " + replacedAgentId);
            if (!BAMBOO_AGENT_ID_VARIABLE.equals(replacedAgentId)) {
                agentId = replacedAgentId;
            }
        }
        catch (Exception e) {
            log.debug("Could not replace agentId variable: " + e.getMessage());
        }
        return agentId;
    }

    private void initializeAWSInteractionParams(CommonTaskContext commonTaskContext, BuildLogger buildLogger) {
        VariableSubstitutor substitutor = this.createVariableSubstitutor(commonTaskContext);
        Map variablesMap = substitutor.getVariableContexts();
        this.maxErrorRetry = 7;
        if (variablesMap.containsKey(MAX_ERROR_RETRY_VARIABLE_KEY)) {
            String value = ((VariableDefinitionContext)variablesMap.get(MAX_ERROR_RETRY_VARIABLE_KEY)).getValue();
            try {
                int maxErrorRetryOverride;
                this.maxErrorRetry = maxErrorRetryOverride = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                buildLogger.addBuildLogEntry("Found non parseable variable value for 'custom.aws.maxErrorRetry':" + value + ", using default instead.");
            }
        }
        buildLogger.addBuildLogEntry("Setting maxErrorRetry=" + this.maxErrorRetry);
    }

    private VariableSubstitutor createVariableSubstitutor(CommonTaskContext commonTaskContext) {
        VariableSubstitutor variableSubstitutor = this.customVariableContext.getVariableSubstitutorFactory().newSubstitutorForCommonContext(commonTaskContext.getCommonContext());
        return variableSubstitutor;
    }

    protected void createAndLogVariable(BuildLogger buildLogger, String variableKey, String variableValue) {
        if (null == this.variableContext) {
            log.error("Can't create variables, variableContext is not initialized.");
            return;
        }
        String namespacedVariableKey = this.prefixVariableNamespace(variableKey);
        String fullVariableKey = VARIABLE_PREFIX_BAMBOO.concat(namespacedVariableKey);
        switch (this.variableScope) {
            case LOCAL: {
                log.trace("Creating local variable: " + namespacedVariableKey);
                this.variableContext.addLocalVariable(namespacedVariableKey, variableValue);
                break;
            }
            case RESULT: {
                log.trace("Creating result variable: " + namespacedVariableKey);
                this.variableContext.addResultVariable(namespacedVariableKey, variableValue);
                break;
            }
            default: {
                log.error("Unknown variableScope: ", (Object)this.variableScope.name());
                this.variableContext.addLocalVariable(namespacedVariableKey, variableValue);
            }
        }
        buildLogger.addBuildLogEntry(String.format("... %s: %s (%s)", new Object[]{fullVariableKey, variableValue, this.variableScope}));
    }

    private void initializeVariablesParams(CommonTaskContext commonTaskContext, BuildLogger buildLogger) {
        this.initializeVariableContext(commonTaskContext);
        this.initializeVariableScope(commonTaskContext);
        this.initializeVariableNamespace(commonTaskContext);
    }

    private void initializeVariableContext(CommonTaskContext commonTaskContext) {
        this.variableContext = commonTaskContext.getCommonContext().getVariableContext();
    }

    protected void initializeVariableScope(CommonTaskContext commonTaskContext) {
        VariableScope scope = BaseTaskConfigurator.VARIABLE_SCOPE_DEFAULT;
        ConfigurationMap configurationMap = commonTaskContext.getConfigurationMap();
        String variableScopeString = (String)configurationMap.get((Object)"variableScope");
        if (StringUtils.isNotBlank((CharSequence)variableScopeString)) {
            try {
                scope = VariableScope.valueOf(variableScopeString);
            }
            catch (Exception e) {
                log.error("Failed to parse scope string to VariableScope enum value: " + variableScopeString, (Throwable)e);
            }
        }
        this.variableScope = scope;
    }

    protected void initializeVariableNamespace(CommonTaskContext commonTaskContext) {
        String namespace = "custom.aws";
        ConfigurationMap configurationMap = commonTaskContext.getConfigurationMap();
        String prefixOverride = (String)configurationMap.get((Object)"variableNamespace");
        if (StringUtils.isNotBlank((CharSequence)prefixOverride)) {
            namespace = prefixOverride;
        }
        this.variableNamespace = namespace;
    }

    protected String prefixVariableNamespace(String postfix) {
        String namespace = this.variableNamespace;
        if (!StringUtils.endsWith((CharSequence)namespace, (CharSequence)".")) {
            namespace = namespace + ".";
        }
        if (postfix.startsWith(".")) {
            postfix = StringUtils.removeStart((String)postfix, (String)".");
        }
        return namespace.concat(postfix);
    }
}

