/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.sso;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import net.utoolity.atlassian.ifaws.aws.AWSIcons;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AWSConsoleLoginUrlCreator {
    private static final Logger log = LoggerFactory.getLogger(AWSConsoleLoginUrlCreator.class);
    private final ApplicationProperties applicationProperties;
    public static final String AWS_CONSOLE_LOGIN_SERVLET_PATH = "/plugins/servlet/identity-federation-for-aws/aws-console-login/";
    private static final String CONSOLE_URL_PATH_PART_CODESUITE = "codesuite";

    public AWSConsoleLoginUrlCreator(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public String createConsoleLoginUrl(String connectorId) {
        return this.createConsoleLoginUrl(connectorId, null);
    }

    public String createConsoleLoginUrl(String connectorId, String destinationUrl) {
        String consoleURL = this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE) + AWS_CONSOLE_LOGIN_SERVLET_PATH + connectorId;
        if (StringUtils.isNotBlank((String)destinationUrl)) {
            try {
                String encodedDestinationUrl = URLEncoder.encode(destinationUrl, "UTF-8");
                consoleURL = consoleURL.concat("?destination=").concat(encodedDestinationUrl);
            }
            catch (UnsupportedEncodingException e) {
                String message = String.format("Failed to encode destination URL '%s'", destinationUrl);
                log.error(message, (Throwable)e);
            }
        }
        return consoleURL;
    }

    public static String extractServiceFromConsoleUrl(String urlString) {
        String service = null;
        try {
            String[] pathParts;
            URL url = new URL(urlString);
            String path = url.getPath();
            if (!StringUtils.isBlank((String)path) && 0 < (pathParts = StringUtils.split((String)path, (String)"/")).length && CONSOLE_URL_PATH_PART_CODESUITE.equals(service = pathParts[0]) && 1 < pathParts.length) {
                service = pathParts[1];
            }
        }
        catch (MalformedURLException e) {
            log.debug("Could not parse {} as URL", (Object)urlString);
        }
        return service;
    }

    public String getIconUrlForService(String service) {
        String internalUrl = AWSIcons.getIconUrlForService(service);
        String url = this.applicationProperties.getBaseUrl(UrlMode.RELATIVE) + internalUrl;
        return url;
    }
}

