/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.model;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import java.util.Objects;
import net.utoolity.atlassian.dry.EncryptionFailureException;
import net.utoolity.atlassian.dry.StaticComponentAccessor;
import net.utoolity.atlassian.ifaws.EncryptionHandler;
import net.utoolity.atlassian.ifaws.ao.AWSAccount;
import net.utoolity.atlassian.ifaws.ao.AWSConnector;
import net.utoolity.atlassian.ifaws.ao.DefaultCloudProvider;
import net.utoolity.atlassian.ifaws.model.AWSAccountEntity;
import net.utoolity.atlassian.ifaws.model.AWSConnectorEntity;
import net.utoolity.atlassian.ifaws.model.AWSConnectorEntityImpl;

public class AWSAccountEntityImpl
implements AWSAccountEntity {
    private final AWSAccount awsAccount;

    public AWSAccountEntityImpl(AWSAccount awsAccount) {
        if (null == awsAccount) {
            throw new RuntimeException("AWSAccountEntity can not be null");
        }
        this.awsAccount = awsAccount;
    }

    @Override
    public AWSCredentials getAWSCredentials() throws EncryptionFailureException {
        String decrypted = this.decryptSecretKey(this.awsAccount.getAWSSecretKey());
        BasicAWSCredentials credentials = new BasicAWSCredentials(this.awsAccount.getAWSAccessKeyId(), decrypted);
        return credentials;
    }

    @Override
    public DefaultCloudProvider getCloudProvider() {
        return DefaultCloudProvider.getByKey(this.awsAccount.getCloudProviderKey());
    }

    private String decryptSecretKey(String awsSecretKey) throws EncryptionFailureException {
        EncryptionHandler encryptionHandler = StaticComponentAccessor.getEncryptionHandler();
        return encryptionHandler.decryptToString(awsSecretKey);
    }

    @Override
    public String getId() {
        return this.awsAccount.getId();
    }

    @Override
    public String getName() {
        return this.awsAccount.getName();
    }

    @Override
    public void setName(String name) {
        this.awsAccount.setName(name);
    }

    @Override
    public String getAWSAccessKeyId() {
        return this.awsAccount.getAWSAccessKeyId();
    }

    @Override
    public void setAWSAccessKeyId(String awsAccessKeyId) {
        this.awsAccount.setAWSAccessKeyId(awsAccessKeyId);
    }

    @Override
    public String getAWSSecretKey() {
        return this.awsAccount.getAWSSecretKey();
    }

    @Override
    public void setAWSSecretKey(String awsSecretKey) {
        this.awsAccount.setAWSSecretKey(awsSecretKey);
    }

    @Override
    public String getCloudProviderKey() {
        return this.awsAccount.getCloudProviderKey();
    }

    @Override
    public void setCloudProviderKey(String cloudProviderKey) {
        this.awsAccount.setCloudProviderKey(cloudProviderKey);
    }

    @Override
    public int getV1Id() {
        return this.awsAccount.getV1Id();
    }

    @Override
    public void setV1Id(int v1Id) {
        this.awsAccount.setV1Id(v1Id);
    }

    @Override
    public AWSConnectorEntity[] getAWSConnectors() {
        AWSConnector[] aoEntities = this.awsAccount.getAWSConnectors();
        AWSConnectorEntity[] results = new AWSConnectorEntity[aoEntities.length];
        for (int i = 0; i < aoEntities.length; ++i) {
            results[i] = new AWSConnectorEntityImpl(aoEntities[i]);
        }
        return results;
    }

    @Override
    public AWSAccount getAWSAccountEntity() {
        return this.awsAccount;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AWSAccountEntityImpl)) {
            return false;
        }
        AWSAccountEntityImpl other = (AWSAccountEntityImpl)obj;
        return this.awsAccount.equals(other.getAWSAccountEntity());
    }

    public int hashCode() {
        return Objects.hash(this.awsAccount);
    }
}

