/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.utoolity.atlassian.dry.PluginInfo;
import net.utoolity.atlassian.dry.WhitelistedPlugin;
import net.utoolity.atlassian.ifaws.FeatureFlag;

public class PluginConfiguration {
    public static final String RESOURCE_BASE_PATH = "net/utoolity/atlassian/ifaws";
    private static final String FEATURE_KEY_PREFIX = "features";
    private static final Set<WhitelistedPlugin> LICENSE_CHECK_PLUGIN_WHITELIST = ImmutableSet.of((Object)new WhitelistedPlugin("net.utoolity.atlassian.bamboo.tasks-for-aws", "rest/tasks-for-aws/1.0/status/license"), (Object)new WhitelistedPlugin("net.utoolity.atlassian.bamboo.notifications-with-aws-bamboo", "rest/notifications-with-aws/1.0/status/license"), (Object)new WhitelistedPlugin("net.utoolity.atlassian.jira.notifications-with-aws-jira", "rest/notifications-with-aws/1.0/status/license"), (Object)new WhitelistedPlugin("net.utoolity.atlassian.bamboo.automation-with-aws-bamboo", "rest/automation-with-aws/1.0/status/license"), (Object)new WhitelistedPlugin("net.utoolity.atlassian.confluence.automation-with-aws-confluence", "rest/automation-with-aws/1.0/status/license"), (Object)new WhitelistedPlugin("net.utoolity.atlassian.bitbucket.automation-with-aws-bitbucket", "rest/automation-with-aws/1.0/status/license"), (Object[])new WhitelistedPlugin[]{new WhitelistedPlugin("net.utoolity.atlassian.jira.automation-with-aws-jira", "rest/automation-with-aws/1.0/status/license"), new WhitelistedPlugin("net.utoolity.atlassian.bitbucket.pipelines-with-aws-bitbucket", "rest/pipelines-with-aws/1.0/status/license")});
    private final PluginSettingsFactory pluginSettingsFactory;
    private final PluginSettings globalPluginSettings;

    public PluginConfiguration(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
    }

    public void writeStringSetting(String settingKey, String value) {
        this.globalPluginSettings.put(settingKey, (Object)value);
    }

    public String readStringSetting(String settingKey) {
        return (String)this.globalPluginSettings.get(settingKey);
    }

    public void deleteStringSetting(String settingKey) {
        this.globalPluginSettings.remove(settingKey);
    }

    public boolean isFeatureEnabled(FeatureFlag featureFlag) {
        String featureSettingKey = this.createFeatureSettingKey(featureFlag);
        String settingValue = this.readStringSetting(featureSettingKey);
        return Boolean.parseBoolean(settingValue);
    }

    public void enableFeature(FeatureFlag featureFlag) {
        String featureSettingKey = this.createFeatureSettingKey(featureFlag);
        this.writeStringSetting(featureSettingKey, Boolean.TRUE.toString());
    }

    public void disableFeature(FeatureFlag featureFlag) {
        String featureSettingKey = this.createFeatureSettingKey(featureFlag);
        this.writeStringSetting(featureSettingKey, Boolean.FALSE.toString());
    }

    private String createSettingKey(String settingKey) {
        return PluginInfo.PLUGIN_SETTINGS_NAMESPACE.concat(".").concat(settingKey);
    }

    private String createFeatureSettingKey(FeatureFlag featureFlag) {
        return this.createSettingKey(FEATURE_KEY_PREFIX.concat(".").concat(featureFlag.getKey()));
    }

    public static Set<WhitelistedPlugin> getLicenseCheckPluginWhitelist() {
        return LICENSE_CHECK_PLUGIN_WHITELIST;
    }
}

