/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.services.securitytoken.model.AssumeRoleResult;
import com.amazonaws.services.securitytoken.model.Credentials;
import com.amazonaws.services.securitytoken.model.GetCallerIdentityRequest;
import com.amazonaws.services.securitytoken.model.GetCallerIdentityResult;
import com.amazonaws.services.securitytoken.model.GetFederationTokenRequest;
import com.amazonaws.services.securitytoken.model.GetFederationTokenResult;
import com.amazonaws.services.securitytoken.model.GetSessionTokenRequest;
import com.amazonaws.services.securitytoken.model.GetSessionTokenResult;
import com.amazonaws.services.securitytoken.model.MalformedPolicyDocumentException;
import com.amazonaws.services.securitytoken.model.PackedPolicyTooLargeException;
import net.utoolity.atlassian.dry.AmazonWebServiceClientFactory;
import net.utoolity.atlassian.dry.ParameterValidationException;
import net.utoolity.atlassian.ifaws.ao.DefaultCloudProvider;
import net.utoolity.atlassian.ifaws.ao.IAMRoleForEC2AndECSService;
import net.utoolity.atlassian.ifaws.api.AWSConnectorType;
import net.utoolity.atlassian.ifaws.api.STSCallerIdentityDTO;
import net.utoolity.atlassian.ifaws.api.STSCredentialsDTO;
import net.utoolity.atlassian.ifaws.model.AWSConnectorEntity;
import org.apache.commons.lang.StringUtils;

public class AWSSecurityTokenClientProxy {
    private static final int STS_USER_NAME_MAX_LENGTH_FEDERATION_TOKEN = 32;
    private static final int STS_USER_NAME_MAX_LENGTH_ASSUME_ROLE = 64;
    private static final String STS_USER_NAME_INVALID_CHAR_REGEX = "[^\\w+=,.@-]";
    private static final String STS_USER_NAME_INVALID_CHAR_REPLACEMENT = "_";
    private final AmazonWebServiceClientFactory clientFactory;

    public AWSSecurityTokenClientProxy(AmazonWebServiceClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    public Credentials getSecurityToken(AWSConnectorEntity awsConnector, Integer durationSeconds, String username) {
        if (AWSConnectorType.PROVIDED == awsConnector.getTypeAsEnum() && !IAMRoleForEC2AndECSService.isEC2PlaceholderAccount(awsConnector.getAWSAccount())) {
            throw new RuntimeException("Can't use provided credentials connector with non EC2/ECS backing credentials");
        }
        AWSCredentials awsCredentials = awsConnector.getLongLivedCredentials();
        DefaultCloudProvider cloudProvider = awsConnector.getCloudProvider();
        AWSSecurityTokenServiceClient stsClient = this.createSTSClient(awsCredentials, cloudProvider);
        switch (awsConnector.getTypeAsEnum()) {
            case SESSION_TOKEN: {
                return this.getSecurityTokenByGetSessionToken(stsClient, awsConnector, durationSeconds);
            }
            case FEDERATION_TOKEN: {
                return this.getSecurityTokenByGetFederationToken(stsClient, awsConnector, durationSeconds, username);
            }
            case ASSUME_ROLE: {
                return this.getSecurityTokenByAssumeRole(stsClient, awsConnector, durationSeconds, username);
            }
            case PROVIDED: {
                Credentials credentials = new Credentials().withAccessKeyId(awsCredentials.getAWSAccessKeyId()).withSecretAccessKey(awsCredentials.getAWSSecretKey());
                if (awsCredentials instanceof AWSSessionCredentials) {
                    credentials.setSessionToken(((AWSSessionCredentials)awsCredentials).getSessionToken());
                }
                return credentials;
            }
        }
        throw new RuntimeException("Unknown connector type");
    }

    public STSCallerIdentityDTO getCallerIdentity(AWSCredentials awsCredentials, DefaultCloudProvider cloudProvider) {
        AWSSecurityTokenServiceClient stsClient = this.createSTSClient(awsCredentials, cloudProvider);
        GetCallerIdentityRequest getCallerIdentityRequest = new GetCallerIdentityRequest();
        GetCallerIdentityResult getCallerIdentityResult = stsClient.getCallerIdentity(getCallerIdentityRequest);
        return new STSCallerIdentityDTO(getCallerIdentityResult.getAccount(), getCallerIdentityResult.getArn(), getCallerIdentityResult.getUserId());
    }

    public STSCallerIdentityDTO getCallerIdentity(STSCredentialsDTO stsCredentialsDTO) {
        BasicSessionCredentials awsCredentials = new BasicSessionCredentials(stsCredentialsDTO.getAccessKeyId(), stsCredentialsDTO.getSecretAccessKey(), stsCredentialsDTO.getSessionToken());
        DefaultCloudProvider cloudProvider = DefaultCloudProvider.getByPartitionKey(stsCredentialsDTO.getPartition());
        return this.getCallerIdentity((AWSCredentials)awsCredentials, cloudProvider);
    }

    private AWSSecurityTokenServiceClient createSTSClient(AWSCredentials awsCredentials, DefaultCloudProvider cloudProvider) {
        AWSSecurityTokenServiceClient stsClient = this.clientFactory.createClient(AWSSecurityTokenServiceClient.class, awsCredentials);
        String endpointURL = cloudProvider.getStsEndpointURL();
        stsClient.setEndpoint(endpointURL);
        return stsClient;
    }

    private AWSSecurityTokenServiceClient createSTSClient(AWSCredentialsProvider awsCredentialsProvider, DefaultCloudProvider cloudProvider) {
        AWSSecurityTokenServiceClient stsClient = this.clientFactory.createClient(AWSSecurityTokenServiceClient.class, awsCredentialsProvider);
        String endpointURL = cloudProvider.getStsEndpointURL();
        stsClient.setEndpoint(endpointURL);
        return stsClient;
    }

    private Credentials getSecurityTokenByGetFederationToken(AWSSecurityTokenServiceClient awsClient, AWSConnectorEntity awsConnector, Integer durationSeconds, String username) throws RuntimeException {
        String sanitizedUsername = AWSSecurityTokenClientProxy.sanitizeNameForSTSUsage(username, 32);
        GetFederationTokenRequest getFederationTokenRequest = new GetFederationTokenRequest().withName(sanitizedUsername);
        if (null == durationSeconds) {
            durationSeconds = this.adjustDurationSecondsDefault(durationSeconds, awsConnector);
        }
        if (null != durationSeconds) {
            this.validateDurationSeconds(durationSeconds, awsConnector);
            getFederationTokenRequest.setDurationSeconds(durationSeconds);
        }
        if (StringUtils.isNotBlank((String)awsConnector.getIAMPolicy())) {
            getFederationTokenRequest.setPolicy(awsConnector.getIAMPolicy());
        }
        if (null != awsConnector.getIAMPolicyArnsCollection() && 0 < awsConnector.getIAMPolicyArnsCollection().size()) {
            getFederationTokenRequest.setPolicyArns(awsConnector.getIAMPolicyArnsCollection());
        }
        try {
            GetFederationTokenResult getFederationTokenResult = awsClient.getFederationToken(getFederationTokenRequest);
            return getFederationTokenResult.getCredentials();
        }
        catch (PackedPolicyTooLargeException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedPolicyDocumentException e) {
            throw new RuntimeException(e);
        }
        catch (AmazonServiceException e) {
            throw new RuntimeException(e);
        }
        catch (AmazonClientException e) {
            throw new RuntimeException(e);
        }
    }

    private Credentials getSecurityTokenByGetSessionToken(AWSSecurityTokenServiceClient awsClient, AWSConnectorEntity awsConnector, Integer durationSeconds) throws RuntimeException {
        GetSessionTokenRequest getSessionTokenRequest = new GetSessionTokenRequest();
        if (null == durationSeconds) {
            durationSeconds = this.adjustDurationSecondsDefault(durationSeconds, awsConnector);
        }
        if (null != durationSeconds) {
            this.validateDurationSeconds(durationSeconds, awsConnector);
            getSessionTokenRequest.setDurationSeconds(durationSeconds);
        }
        try {
            GetSessionTokenResult getSessionTokenResult = awsClient.getSessionToken(getSessionTokenRequest);
            return getSessionTokenResult.getCredentials();
        }
        catch (AmazonServiceException e) {
            throw new RuntimeException(e);
        }
        catch (AmazonClientException e) {
            throw new RuntimeException(e);
        }
    }

    private Credentials getSecurityTokenByAssumeRole(AWSSecurityTokenServiceClient awsClient, AWSConnectorEntity awsConnector, Integer durationSeconds, String roleSessionName) {
        String sanitizedRoleSessionName = AWSSecurityTokenClientProxy.sanitizeNameForSTSUsage(roleSessionName, 64);
        AssumeRoleRequest assumeRoleRequest = new AssumeRoleRequest().withRoleArn(awsConnector.getRoleArn()).withRoleSessionName(sanitizedRoleSessionName);
        if (null == durationSeconds) {
            durationSeconds = this.adjustDurationSecondsDefault(durationSeconds, awsConnector);
        }
        if (null != durationSeconds) {
            this.validateDurationSeconds(durationSeconds, awsConnector);
            assumeRoleRequest.setDurationSeconds(durationSeconds);
        }
        if (StringUtils.isNotBlank((String)awsConnector.getIAMPolicy())) {
            assumeRoleRequest.setPolicy(awsConnector.getIAMPolicy());
        }
        if (null != awsConnector.getIAMPolicyArnsCollection() && 0 < awsConnector.getIAMPolicyArnsCollection().size()) {
            assumeRoleRequest.setPolicyArns(awsConnector.getIAMPolicyArnsCollection());
        }
        if (StringUtils.isNotBlank((String)awsConnector.getExternalId())) {
            assumeRoleRequest.setExternalId(awsConnector.getExternalId());
        }
        try {
            AssumeRoleResult assumeRoleResult = awsClient.assumeRole(assumeRoleRequest);
            return assumeRoleResult.getCredentials();
        }
        catch (PackedPolicyTooLargeException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedPolicyDocumentException e) {
            throw new RuntimeException(e);
        }
        catch (AmazonServiceException e) {
            throw new RuntimeException(e);
        }
        catch (AmazonClientException e) {
            throw new RuntimeException(e);
        }
    }

    private Integer adjustDurationSecondsDefault(Integer durationSeconds, AWSConnectorEntity awsConnector) {
        if (null != durationSeconds) {
            return durationSeconds;
        }
        return awsConnector.getDurationSecondsMax();
    }

    private void validateDurationSeconds(Integer durationSeconds, AWSConnectorEntity awsConnector) {
        if (null == durationSeconds) {
            return;
        }
        Integer durationSecondsMin = awsConnector.getTypeAsEnum().getDurationSecondsMin();
        if (durationSeconds < durationSecondsMin) {
            throw new ParameterValidationException("Requested duration is to short - minimum is " + durationSecondsMin.toString());
        }
        Integer durationSecondsMax = awsConnector.getDurationSecondsMax();
        if (null == durationSecondsMax) {
            durationSecondsMax = awsConnector.getTypeAsEnum().getDurationSecondsMax();
        }
        if (durationSeconds > durationSecondsMax) {
            throw new ParameterValidationException("Requested duration is to long - maximum is " + durationSecondsMax.toString());
        }
    }

    public static String sanitizeNameForSTSUsage(String username, int maxLength) {
        String sanitized = username.replaceAll(STS_USER_NAME_INVALID_CHAR_REGEX, STS_USER_NAME_INVALID_CHAR_REPLACEMENT);
        if (sanitized.length() > maxLength) {
            sanitized = sanitized.substring(0, maxLength);
        }
        return sanitized;
    }
}

