/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.bamboo.ifaws.vcs;

import com.atlassian.bamboo.commit.CommitFile;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.viewer.runtime.VcsRepositoryViewer;
import java.net.URI;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.utoolity.atlassian.ifaws.sso.AWSConsoleLoginUrlCreator;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeCommitVcsRepositoryViewer
implements VcsRepositoryViewer {
    private static final Logger log = LoggerFactory.getLogger(CodeCommitVcsRepositoryViewer.class);
    private final CustomVariableContext customVariableContext;
    private final AWSConsoleLoginUrlCreator awsConsoleLoginUrlCreator;

    public CodeCommitVcsRepositoryViewer(CustomVariableContext customVariableContext, AWSConsoleLoginUrlCreator awsConsoleLoginUrlCreator) {
        this.customVariableContext = customVariableContext;
        this.awsConsoleLoginUrlCreator = awsConsoleLoginUrlCreator;
    }

    @Nullable
    public String getWebRepositoryUrlForFile(@NotNull CommitFile file, @NotNull VcsRepositoryData repositoryData) {
        return this.createCodeCommitConsoleLink(repositoryData, "browse/--/" + file.getName());
    }

    @Nullable
    public String getWebRepositoryUrlForFileDiff(@NotNull CommitFile file, @NotNull VcsRepositoryData repositoryData) {
        return this.createCodeCommitConsoleLink(repositoryData, "commit/" + file.getRevision());
    }

    @Nullable
    public String getWebRepositoryUrlForFileRevision(@NotNull CommitFile file, @NotNull VcsRepositoryData repositoryData) {
        return this.createCodeCommitConsoleLink(repositoryData, "browse/" + file.getRevision() + "/--/" + file.getName());
    }

    @Nullable
    public String getWebRepositoryUrlForRevision(@NotNull String revisionId, @NotNull VcsRepositoryData repositoryData) {
        return this.createCodeCommitConsoleLink(repositoryData, "commit/" + revisionId);
    }

    @NotNull
    public Map<String, String> getWebRepositoryUrlForRevisions(Stream<String> revisionIds, VcsRepositoryData repositoryDefinition) {
        return revisionIds.collect(Collectors.toMap(revId -> revId, revId -> this.getWebRepositoryUrlForRevision((String)revId, repositoryDefinition)));
    }

    private String createCodeCommitConsoleLink(@NotNull VcsRepositoryData repositoryData, @NotNull String suffix) {
        if (!repositoryData.getPluginKey().equals("com.atlassian.bamboo.plugins.atlassian-bamboo-plugin-git:gitv2")) {
            log.warn("Cannot generate link for CodeCommit web repository viewer: Repository is not of type Git v2.");
            return null;
        }
        Map configuration = repositoryData.getVcsLocation().getConfiguration();
        URI repositoryUrl = URI.create((String)configuration.get("repository.git.repositoryUrl"));
        String link = this.getCodeCommitBaseUrl(repositoryUrl.getHost(), repositoryUrl.getPath(), suffix);
        return this.addOptionalSSOIndirection(link, repositoryData);
    }

    private String getCodeCommitBaseUrl(String host, String path, String suffix) {
        String[] hostParts;
        if (host != null && path != null && (hostParts = host.split("\\."))[0].equals("git-codecommit")) {
            String region = hostParts[1];
            String[] repoParts = path.split("/", 4);
            String repositorySlug = repoParts[3];
            return String.format("https://%s.console.aws.amazon.com/codesuite/codecommit/repositories/%s/%s?region=%s", region, repositorySlug, suffix, region);
        }
        log.warn("Cannot generate link for CodeCommit web repository viewer: Repository definition does not match CodeCommit repository URL.");
        return null;
    }

    private String addOptionalSSOIndirection(String link, VcsRepositoryData repositoryData) {
        boolean shouldTrySSO;
        String newLink = link;
        Map config = repositoryData.getViewerConfiguration().getConfiguration();
        String connectorIdSelection = (String)config.get("awsConnectorId");
        boolean bl = shouldTrySSO = StringUtils.isNotBlank((String)connectorIdSelection) && !"AWS_CONNECTOR_NO_CONNECTOR_KEY".equals(connectorIdSelection);
        if (shouldTrySSO) {
            String connectorId = connectorIdSelection;
            if ("AWS_CONNECTOR_VARIABLE_KEY".equals(connectorIdSelection)) {
                String variable = (String)config.get("awsConnectorIdVariable");
                connectorId = this.customVariableContext.substituteString(variable);
            }
            newLink = this.awsConsoleLoginUrlCreator.createConsoleLoginUrl(connectorId, link);
        }
        return newLink;
    }
}

