/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.rest.v21;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import net.utoolity.atlassian.dry.LicenseHelper;
import net.utoolity.atlassian.dry.ParameterValidationException;
import net.utoolity.atlassian.ifaws.AWSConnectorValidationResult;
import net.utoolity.atlassian.ifaws.AWSConnectorValidator;
import net.utoolity.atlassian.ifaws.ao.AWSConnectorPersistenceService;
import net.utoolity.atlassian.ifaws.api.AWSConnectorDTO21;
import net.utoolity.atlassian.ifaws.api.AWSConnectorScope;
import net.utoolity.atlassian.ifaws.api.AWSConnectorService21;
import net.utoolity.atlassian.ifaws.api.STSCallerIdentityDTO;
import net.utoolity.atlassian.ifaws.api.STSCredentialsDTO;
import net.utoolity.atlassian.ifaws.api.impl.AWSConnectorService21Impl;
import net.utoolity.atlassian.ifaws.model.AWSAccountEntity;
import net.utoolity.atlassian.ifaws.model.AWSConnectorEntity;
import net.utoolity.atlassian.ifaws.rest.common.DTOCollectionImpl;
import net.utoolity.atlassian.ifaws.rest.common.ErrorResponseDTO;
import net.utoolity.atlassian.ifaws.rest.common.GenericRestException;
import net.utoolity.atlassian.ifaws.rest.v2.ConsoleUrlDTO;
import net.utoolity.atlassian.ifaws.rest.v2.CustomStatus;
import net.utoolity.atlassian.ifaws.sso.AWSConsoleLoginUrlCreator;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
@Path(value="/connectors")
public class AWSConnectorResource {
    private final AWSConnectorService21 awsConnectorService21;
    private final LicenseHelper licenseHelper;
    private final AWSConnectorPersistenceService awsConnectorPersistenceService;
    private final AWSConnectorValidator awsConnectorValidator;
    private final AWSConsoleLoginUrlCreator awsConsoleLoginUrlCreator;

    @Autowired
    public AWSConnectorResource(AWSConnectorService21 awsConnectorService21, LicenseHelper licenseHelper, AWSConnectorPersistenceService awsConnectorPersistenceService, AWSConnectorValidator awsConnectorValidator, AWSConsoleLoginUrlCreator awsConsoleLoginUrlCreator) {
        this.awsConnectorService21 = awsConnectorService21;
        this.licenseHelper = licenseHelper;
        this.awsConnectorPersistenceService = awsConnectorPersistenceService;
        this.awsConnectorValidator = awsConnectorValidator;
        this.awsConsoleLoginUrlCreator = awsConsoleLoginUrlCreator;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getConnectors(@QueryParam(value="scope") String scopeParam) {
        AWSConnectorScope scope = this.parseScopeParam(scopeParam);
        List<AWSConnectorDTO21> connectors = this.awsConnectorService21.getConnectors(scope);
        DTOCollectionImpl<AWSConnectorDTO21> connectorCollection = new DTOCollectionImpl<AWSConnectorDTO21>(connectors);
        return Response.ok(connectorCollection).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response post(AWSConnectorDTO21 connectorData, @Context HttpServletRequest request) {
        this.licenseHelper.ensureValidLicense();
        Map<String, Object> valueMap = this.createConnectorValueMap(connectorData);
        valueMap.remove("ID");
        AWSConnectorValidationResult validationResult = this.awsConnectorValidator.validateValueMap(valueMap, true, true);
        if (!validationResult.hasErrors()) {
            valueMap.remove("AWS_ACCOUNT");
            valueMap.remove("GROUPS");
            AWSConnectorEntity connector = this.awsConnectorPersistenceService.create(valueMap);
            connector = this.awsConnectorPersistenceService.updateGroups(connector, connectorData.getGroups());
            return Response.ok((Object)AWSConnectorService21Impl.createAWSConnectorDTO21(connector)).build();
        }
        CustomStatus responseStatus = validationResult.hasConsistencyErrorsOnly() ? CustomStatus.UNPROCESSABLE_ENTITY : Response.Status.BAD_REQUEST;
        ErrorResponseDTO responseEntity = new ErrorResponseDTO(responseStatus, String.valueOf(responseStatus.getStatusCode()), responseStatus.getReasonPhrase());
        for (Map.Entry<String, String> entry : validationResult.getAllErrors().entrySet()) {
            responseEntity.addErrorMessage(entry.getKey() + " - " + entry.getValue());
        }
        return Response.status((Response.StatusType)responseEntity.getStatus()).entity((Object)responseEntity).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    public Response getConnector(@PathParam(value="id") String connectorId) {
        AWSConnectorDTO21 connector = null;
        connector = this.awsConnectorService21.getConnector(connectorId);
        if (null == connector) {
            throw new GenericRestException().withResponseStatus(Response.Status.NOT_FOUND);
        }
        return Response.ok((Object)connector).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    public Response put(@PathParam(value="id") String connectorId, AWSConnectorDTO21 connectorData, @Context HttpServletRequest request) {
        this.licenseHelper.ensureValidLicense();
        AWSConnectorEntity connector = null;
        connector = this.awsConnectorPersistenceService.getById(connectorId);
        if (null == connector) {
            throw new GenericRestException().withResponseStatus(Response.Status.NOT_FOUND);
        }
        if (!connectorId.equals(connectorData.getId())) {
            throw new GenericRestException().withResponseStatus(Response.Status.CONFLICT);
        }
        Map<String, Object> valueMap = this.createConnectorValueMap(connectorData);
        AWSConnectorValidationResult validationResult = this.awsConnectorValidator.validateValueMap(valueMap, false, true);
        if (!validationResult.hasErrors()) {
            connector.setName((String)valueMap.get("NAME"));
            connector.setType((String)valueMap.get("TYPE"));
            connector.setScope((AWSConnectorScope)valueMap.get("SCOPE"));
            connector.setAWSAccount((AWSAccountEntity)valueMap.get("AWS_ACCOUNT"));
            connector.setRoleArn((String)valueMap.get("ROLE_ARN"));
            connector.setExternalId((String)valueMap.get("EXTERNAL_ID"));
            connector.setIAMPolicy((String)valueMap.get("IAM_POLICY"));
            connector.setDurationSecondsMax((Integer)valueMap.get("DURATION_SECONDS_MAX"));
            connector = this.awsConnectorPersistenceService.save(connector);
            connector = this.awsConnectorPersistenceService.updateGroups(connector, connectorData.getGroups());
            return Response.ok((Object)AWSConnectorService21Impl.createAWSConnectorDTO21(connector)).build();
        }
        CustomStatus responseStatus = validationResult.hasConsistencyErrorsOnly() ? CustomStatus.UNPROCESSABLE_ENTITY : Response.Status.BAD_REQUEST;
        ErrorResponseDTO responseEntity = new ErrorResponseDTO(responseStatus, String.valueOf(responseStatus.getStatusCode()), responseStatus.getReasonPhrase());
        for (Map.Entry<String, String> entry : validationResult.getAllErrors().entrySet()) {
            responseEntity.addErrorMessage(entry.getKey() + " - " + entry.getValue());
        }
        return Response.status((Response.StatusType)responseEntity.getStatus()).entity((Object)responseEntity).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    public Response delete(@PathParam(value="id") String connectorId) {
        this.licenseHelper.ensureValidLicense();
        AWSConnectorEntity connector = null;
        connector = this.awsConnectorPersistenceService.getById(connectorId);
        if (null == connector) {
            throw new GenericRestException().withResponseStatus(Response.Status.NOT_FOUND);
        }
        this.awsConnectorPersistenceService.delete(connector);
        return Response.ok().build();
    }

    private AWSConnectorScope parseScopeParam(String scopeParam) throws ParameterValidationException {
        AWSConnectorScope scope = null;
        if (StringUtils.isNotBlank((String)scopeParam)) {
            try {
                scope = AWSConnectorScope.valueOf(scopeParam);
            }
            catch (IllegalArgumentException iae) {
                throw new ParameterValidationException("Unknown scope value: " + scopeParam);
            }
        }
        return scope;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{id}/credentials")
    public Response getCredentials(@PathParam(value="id") String connectorId, @QueryParam(value="durationSeconds") Integer durationSeconds) {
        STSCredentialsDTO credentials = this.awsConnectorService21.getCredentials(connectorId, durationSeconds);
        if (null == credentials) {
            throw new GenericRestException().withResponseStatus(Response.Status.NOT_FOUND);
        }
        return Response.ok((Object)credentials).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{id}/caller-identity")
    public Response getCallerIdentity(@PathParam(value="id") String connectorId) {
        STSCallerIdentityDTO stsCallerIdentityDTO = this.awsConnectorService21.getCallerIdentity(connectorId);
        if (null == stsCallerIdentityDTO) {
            throw new GenericRestException().withResponseStatus(Response.Status.NOT_FOUND);
        }
        return Response.ok((Object)stsCallerIdentityDTO).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{id}/console/url")
    public Response getConsoleUrl(@PathParam(value="id") String connectorId, @Encoded @QueryParam(value="destination") List<String> destination) {
        AWSConnectorDTO21 connector = null;
        connector = this.awsConnectorService21.getConnector(connectorId);
        if (null == connector) {
            throw new GenericRestException().withResponseStatus(Response.Status.NOT_FOUND);
        }
        if (destination.size() > 1) {
            throw new GenericRestException("Only one destination parameter allowed").withResponseStatus(Response.Status.BAD_REQUEST);
        }
        String destinationUrl = null;
        if (destination.size() == 1 && StringUtils.isNotBlank((String)destination.get(0))) {
            destinationUrl = destination.get(0);
        }
        String consoleURL = this.awsConsoleLoginUrlCreator.createConsoleLoginUrl(connectorId, destinationUrl);
        ConsoleUrlDTO consoleUrlDTO = ConsoleUrlDTO.fromUrl(consoleURL);
        return Response.ok((Object)consoleUrlDTO).build();
    }

    private Map<String, Object> createConnectorValueMap(AWSConnectorDTO21 connectorData) {
        Map<String, Object> propertyMap = this.awsConnectorPersistenceService.createEmptyPropertyMap();
        propertyMap.remove("V1_ID");
        propertyMap.remove("AWS_ACCOUNT");
        if (null != connectorData.getId()) {
            propertyMap.put("ID", StringUtils.trim((String)connectorData.getId()));
        }
        propertyMap.put("NAME", StringUtils.trim((String)connectorData.getName()));
        propertyMap.put("AWS_ACCOUNTID", StringUtils.trim((String)connectorData.getAccountId()));
        propertyMap.put("DURATION_SECONDS_MAX", connectorData.getDurationSecondsMax());
        propertyMap.put("EXTERNAL_ID", StringUtils.trim((String)connectorData.getExternalId()));
        propertyMap.put("GROUPS", connectorData.getGroups());
        propertyMap.put("IAM_POLICY", StringUtils.trim((String)connectorData.getIamPolicy()));
        propertyMap.put("ROLE_ARN", StringUtils.trim((String)connectorData.getRoleArn()));
        propertyMap.put("SCOPE", this.parseScopeParam(StringUtils.trim((String)connectorData.getScope())));
        propertyMap.put("TYPE", StringUtils.trim((String)connectorData.getType()));
        return propertyMap;
    }

    @VisibleForTesting
    public Map<String, Object> testCreateConnectorValueMap(AWSConnectorDTO21 connectorData) {
        return this.createConnectorValueMap(connectorData);
    }
}

