/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.rest.v1;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import net.utoolity.atlassian.dry.LicenseHelper;
import net.utoolity.atlassian.ifaws.ao.AWSAccountPersistenceService;
import net.utoolity.atlassian.ifaws.api.AWSAccountDTO;
import net.utoolity.atlassian.ifaws.model.AWSAccountEntity;
import net.utoolity.atlassian.ifaws.rest.common.DTOCollectionImpl;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
@Path(value="/accounts")
public class AWSAccountResource {
    private final LicenseHelper licenseHelper;
    private final AWSAccountPersistenceService awsAccountPersistenceService;

    @Autowired
    public AWSAccountResource(LicenseHelper licenseHelper, AWSAccountPersistenceService awsAccountPersistenceService) {
        this.licenseHelper = licenseHelper;
        this.awsAccountPersistenceService = awsAccountPersistenceService;
    }

    @GET
    @Produces(value={"application/json"})
    public Response findAccounts() {
        this.licenseHelper.ensureValidLicense();
        AWSAccountEntity[] accounts = this.awsAccountPersistenceService.findAll();
        ArrayList<AWSAccountDTO> accountDataList = new ArrayList<AWSAccountDTO>();
        for (AWSAccountEntity account : accounts) {
            accountDataList.add(AWSAccountResource.fromAWSAccount(account));
        }
        DTOCollectionImpl accountDataCollection = new DTOCollectionImpl(accountDataList);
        return Response.ok(accountDataCollection).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response post(AWSAccountDTO accountData, @Context HttpServletRequest request) {
        this.licenseHelper.ensureValidLicense();
        Map<String, Object> propertyMap = this.awsAccountPersistenceService.createEmptyPropertyMap();
        propertyMap.remove("ID");
        propertyMap.remove("V1_ID");
        propertyMap.put("NAME", accountData.getName().trim());
        propertyMap.put("AWS_ACCESS_KEY_ID", accountData.getAWSAccessKeyId().trim());
        propertyMap.put("AWS_SECRET_KEY", accountData.getAWSSecretKey().trim());
        propertyMap.put("CLOUD_PROVIDER_KEY", accountData.getCloudProviderKey().trim());
        AWSAccountEntity account = this.awsAccountPersistenceService.create(propertyMap);
        return Response.ok((Object)AWSAccountResource.fromAWSAccount(account)).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    public Response getAccount(@PathParam(value="id") Integer accountId) {
        this.licenseHelper.ensureValidLicense();
        AWSAccountEntity account = null;
        account = this.awsAccountPersistenceService.getByV1Id(accountId);
        if (null == account) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)AWSAccountResource.fromAWSAccount(account)).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    public Response put(@PathParam(value="id") Integer accountId, AWSAccountDTO accountData, @Context HttpServletRequest request) {
        boolean secretKeyChanged;
        this.licenseHelper.ensureValidLicense();
        AWSAccountEntity account = null;
        account = this.awsAccountPersistenceService.getByV1Id(accountId);
        if (null == account) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (accountData.getId() != accountId.intValue()) {
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        account.setName(accountData.getName().trim());
        account.setAWSAccessKeyId(accountData.getAWSAccessKeyId().trim());
        boolean bl = secretKeyChanged = !accountData.getAWSSecretKey().equals("Secret key intentionally retained");
        if (secretKeyChanged) {
            account.setAWSSecretKey(accountData.getAWSSecretKey().trim());
        }
        account.setCloudProviderKey(accountData.getCloudProviderKey().trim());
        account = this.awsAccountPersistenceService.save(account, secretKeyChanged);
        return Response.ok((Object)AWSAccountResource.fromAWSAccount(account)).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    public Response delete(@PathParam(value="id") Integer accountId) {
        this.licenseHelper.ensureValidLicense();
        AWSAccountEntity account = null;
        account = this.awsAccountPersistenceService.getByV1Id(accountId);
        if (null == account) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.awsAccountPersistenceService.delete(account);
        return Response.ok().build();
    }

    public static AWSAccountDTO fromAWSAccount(AWSAccountEntity awsAccount) {
        AWSAccountDTO awsAccountData = new AWSAccountDTO();
        awsAccountData.setId(awsAccount.getV1Id());
        awsAccountData.setId2(awsAccount.getId());
        awsAccountData.setName(awsAccount.getName());
        awsAccountData.setAWSAccessKeyId(awsAccount.getAWSAccessKeyId());
        awsAccountData.setAWSSecretKey("Secret key intentionally retained");
        awsAccountData.setCloudProviderKey(awsAccount.getCloudProviderKey());
        awsAccountData.setIsDeletable(1 > awsAccount.getAWSConnectors().length);
        return awsAccountData;
    }
}

