/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.api.impl;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import java.util.ArrayList;
import java.util.List;
import net.utoolity.atlassian.dry.LicenseHelper;
import net.utoolity.atlassian.ifaws.AWSSecurityTokenClientProxy;
import net.utoolity.atlassian.ifaws.PluginConfiguration;
import net.utoolity.atlassian.ifaws.ao.AWSConnectorPersistenceService;
import net.utoolity.atlassian.ifaws.api.AWSConnectorDTO21;
import net.utoolity.atlassian.ifaws.api.AWSConnectorScope;
import net.utoolity.atlassian.ifaws.api.AWSConnectorService21;
import net.utoolity.atlassian.ifaws.api.LicenseException;
import net.utoolity.atlassian.ifaws.api.NotAuthorizedException;
import net.utoolity.atlassian.ifaws.api.impl.AWSConnectorService2ImplBase;
import net.utoolity.atlassian.ifaws.model.AWSConnectorEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService(value={AWSConnectorService21.class})
@Component
public class AWSConnectorService21Impl
extends AWSConnectorService2ImplBase
implements AWSConnectorService21 {
    @Autowired
    public AWSConnectorService21Impl(LicenseHelper licenseHelper, AWSConnectorPersistenceService awsConnectorPersistenceService, AWSSecurityTokenClientProxy tokenClientProxy, @ComponentImport UserManager userManager, PluginConfiguration pluginConfiguration) {
        super(licenseHelper, awsConnectorPersistenceService, tokenClientProxy, userManager, pluginConfiguration);
    }

    @Override
    public List<AWSConnectorDTO21> getConnectors() throws LicenseException {
        return this.getConnectors(null);
    }

    @Override
    public List<AWSConnectorDTO21> getConnectors(AWSConnectorScope awsConnectorScope) throws LicenseException {
        this.licenseHelper.ensureValidLicense();
        UserKey userKey = this.findCurrentUserKey();
        AWSConnectorEntity[] matches = null != awsConnectorScope ? this.awsConnectorPersistenceService.findByScope(awsConnectorScope) : this.awsConnectorPersistenceService.findAll();
        ArrayList<AWSConnectorDTO21> result = new ArrayList<AWSConnectorDTO21>();
        for (AWSConnectorEntity awsConnector : matches) {
            if (!this.hasAccess(userKey, awsConnector, null)) continue;
            result.add(AWSConnectorService21Impl.createAWSConnectorDTO21(awsConnector));
        }
        return result;
    }

    @Override
    public AWSConnectorDTO21 getConnector(String connectorId) throws NotAuthorizedException, LicenseException {
        return this.getConnector(connectorId, null);
    }

    @Override
    public AWSConnectorDTO21 getConnector(String connectorId, AWSConnectorScope awsConnectorScope) throws NotAuthorizedException, LicenseException {
        this.licenseHelper.ensureValidLicense();
        AWSConnectorEntity awsConnector = this.awsConnectorPersistenceService.getById(connectorId);
        UserKey userKey = this.findCurrentUserKey();
        if (null == awsConnector) {
            return null;
        }
        if (!this.hasAccess(userKey, awsConnector, awsConnectorScope)) {
            throw new NotAuthorizedException("Requesting user is not authorized to access this Connector");
        }
        return AWSConnectorService21Impl.createAWSConnectorDTO21(awsConnector);
    }

    public static AWSConnectorDTO21 createAWSConnectorDTO21(AWSConnectorEntity awsConnector) {
        AWSConnectorDTO21 awsConnectorDTO21 = new AWSConnectorDTO21();
        awsConnectorDTO21.setId(awsConnector.getId());
        awsConnectorDTO21.setName(awsConnector.getName());
        awsConnectorDTO21.setType(awsConnector.getType());
        awsConnectorDTO21.setScope(null != awsConnector.getScope() ? awsConnector.getScope().name() : null);
        awsConnectorDTO21.setDurationSecondsMax(awsConnector.getDurationSecondsMax());
        if (null != awsConnector.getCloudProvider()) {
            awsConnectorDTO21.setPartition(awsConnector.getCloudProvider().getPartitionKey());
        }
        awsConnectorDTO21.setAccountId(awsConnector.getAWSAccount().getId());
        awsConnectorDTO21.setRoleArn(awsConnector.getRoleArn());
        awsConnectorDTO21.setExternalId(awsConnector.getExternalId());
        awsConnectorDTO21.setIamPolicy(awsConnector.getIAMPolicy());
        awsConnectorDTO21.setGroups(awsConnector.getGroupNames());
        return awsConnectorDTO21;
    }
}

