AJS.toInit(function () {
    var contextPath = AJS.contextPath();
    // Prepare additional environment field entries
    var placeholder = "Not fetched yet"; // Prepare for REST request delay/timeout/failure
    
    var pluginInfoSuccessHandler = function(response) {
        var environment = window.ATL_JQ_PAGE_PROPS.environment;
        if (response.hasOwnProperty("applicationName")) {
            environment.ApplicationName = response.applicationName;
        }
        if (response.hasOwnProperty("applicationVersion")) {
            environment.ApplicationVersion = response.applicationVersion;
        }
        if (response.hasOwnProperty("pluginName")) {
            environment.PluginName = response.pluginName;
        }
        if (response.hasOwnProperty("pluginVersion")) {
            environment.PluginVersion = response.pluginVersion;
        }
        if (response.hasOwnProperty("hostEdition")) {
          environment.HostEdition = response.hostEdition;
        }
        if (response.hasOwnProperty("hostIsDataCenter")) {
          environment.HostIsDataCenter = response.hostIsDataCenter;
        }
        if (response.hasOwnProperty("hostIsEvaluation")) {
          environment.HostIsEvaluation = response.hostIsEvaluation;
        }
        if (response.hasOwnProperty("hostSen")) {
          environment.HostSen = response.hostSen;
        }
    };

    AJS.$.ajax({
        url: contextPath + "/rest/identity-federation-for-aws/2.0/status/info",
        type: "GET",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: pluginInfoSuccessHandler,
    });

    // Add issue collector
    AJS.$.ajax({
        url : "https://utoolity.atlassian.net/s/en_US-7hdsqe-1988229788/6095/157/1.4.0-m2/_/download/batch/com.atlassian.jira.collector.plugin.jira-issue-collector-plugin:issuecollector-embededjs/com.atlassian.jira.collector.plugin.jira-issue-collector-plugin:issuecollector-embededjs.js?collectorId=ae271f00",
        type : "get",
        cache : true,
        dataType : "script"
    });

    // Configure issue collector
    window.ATL_JQ_PAGE_PROPS = {
        "triggerFunction" : function(showCollectorDialog) {
            // Requries that jQuery is available!
            jQuery("#ifaws-atlwdg-trigger").click(function(e) {
                e.preventDefault();
                showCollectorDialog();
            });
        },
        environment : {
            'ApplicationName'  : placeholder,
            'ApplicationVersion' : placeholder,
            'PluginName' : placeholder,
            'PluginVersion' : placeholder
        },
        fieldValues: {
            security : '10006'
        }
    };
});
