AJS.toInit(function () {
    // Nothing to do, if trigger not available (e.g. on license error)
    if (AJS.$("#ifaws-add-new-connector-trigger").length > 0) {
        var createConnectorDiscoveryDialog = AJS.InlineDialog(AJS.$("#ifaws-add-new-connector-trigger"), "create-connector-discovery",
            function(content, trigger, showPopup) {
                content.append(AJS.$("<a/>")
                        .css({"float":"right"})
                        .click(function() {
                            createConnectorDiscoveryDialog.hide();
                        })
                        .append("<span title=\"Close\" class=\"aui-icon aui-icon-close\">Close</span>")
                );
                content.append(AJS.$("<h3/>")
                        .css({"display":"inline"})
                        .append(AJS.I18n.getText("ifaws.configAWSConnectorOverview.userHint.title"))
                );
                content.append(AJS.$("<p/>")
                        .append(AJS.I18n.getText("ifaws.configAWSConnectorOverview.userHint.message"))
                );
                content.css({"padding":"20px"})
                showPopup();
                return false;
            },
            {
                noBind: true,
                hideDelay: null,
                fadeTime: 2000,
                persistent: false
            }
        );

        // NOTE: Need to check for empty search term as well, otherwise this would
        // trigger for an empty table after matchless filter
        if (AJS.$("#ifaws-connector-overview-table > tbody > tr").length < 1 && !AJS.$("#search-term").val()) {
            createConnectorDiscoveryDialog.show();
        }
        AJS.$("#ifaws-add-new-connector-trigger").click(function() {
            createConnectorDiscoveryDialog.hide();
        });
    };
    // Trigger hover functionality for connector id copy text
    AJS.$(".ifaws-connector-hover-toggle-trigger").hover(
            function() {
                AJS.$(this).find(".ifaws-connector-hover-toggle")
                        .toggleClass("ifaws-visibility-hidden");
            });
    // Trigger clipboard functionality for connector ids
    var ifawsClipboard = new Clipboard(
            '.ifaws-connector-id-copy-trigger', {
                target : function(trigger) {
                    return trigger.previousElementSibling;
                }
            });
    // Register temporary credentials dialog behavior
    AJS.$('.ifaws-temporary-credentials-trigger-link').on('click', function(e) {
        e.preventDefault();
        const dataState = AJS.$(this).data('state');
        const dataConnectorId = AJS.$(this).data('connector-id');
        const dialogId = '#ifaws-temporary-credentials-dialog-' + dataConnectorId;
        const dialog = AJS.dialog2(dialogId);
        dialog.on('show', () => {
          AJS.$(dialogId + ' .aui-dialog2-content').append('<div id="IFAWSTemporaryCredentialsModal" style="height: 100%;" data-state="' + dataState + '" data-i18n="en" />');
        });
        dialog.on('hide', () => {
          while (AJS.$('#IFAWSTemporaryCredentialsModal').length > 0) {
            AJS.$('#IFAWSTemporaryCredentialsModal').remove();
          }
        });
        dialog.show();
    });
});
