/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.ao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.io.UnsupportedEncodingException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import net.utoolity.atlassian.dry.EncryptionFailureException;
import net.utoolity.atlassian.ifaws.EncryptionHandler;
import net.utoolity.atlassian.ifaws.ao.AWSAccount;
import net.utoolity.atlassian.ifaws.ao.AWSAccountPersistenceService;
import net.utoolity.atlassian.ifaws.ao.AWSAccountPredicates;
import net.utoolity.atlassian.ifaws.model.AWSAccountEntity;
import net.utoolity.atlassian.ifaws.model.AWSAccountEntityImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AWSAccountPersistenceServiceImpl
implements AWSAccountPersistenceService {
    private final ActiveObjects ao;
    private final EncryptionHandler encryptionHandler;

    @Autowired
    public AWSAccountPersistenceServiceImpl(@ComponentImport ActiveObjects ao, EncryptionHandler encryptionHandler) {
        this.ao = ao;
        this.encryptionHandler = encryptionHandler;
    }

    @Override
    public AWSAccountEntity getById(final String id) {
        AWSAccount aoEntity = (AWSAccount)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<AWSAccount>(){

            public AWSAccount doInTransaction() {
                return AWSAccountPersistenceServiceImpl.this.getByIdOutsideTransaction(id);
            }
        });
        return this.createAWSAccountOrNull(aoEntity);
    }

    private AWSAccount getByIdOutsideTransaction(String id) {
        return (AWSAccount)this.ao.get(AWSAccount.class, (Object)id);
    }

    @Override
    public AWSAccountEntity getByV1Id(final int v1Id) {
        AWSAccount aoEntity = (AWSAccount)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<AWSAccount>(){

            public AWSAccount doInTransaction() {
                String whereClause = "V1_ID = ?";
                int param = v1Id;
                Query query = Query.select().where(whereClause, new Object[]{param});
                return ((AWSAccount[])AWSAccountPersistenceServiceImpl.this.ao.find(AWSAccount.class, query))[0];
            }
        });
        return this.createAWSAccountOrNull(aoEntity);
    }

    @Override
    public AWSAccountEntity create(final Map<String, Object> params) {
        AWSAccount aoEntity = (AWSAccount)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<AWSAccount>(){

            public AWSAccount doInTransaction() {
                params.put("AWS_SECRET_KEY", AWSAccountPersistenceServiceImpl.this.encryptSecretKey((String)params.get("AWS_SECRET_KEY")));
                AWSAccount account = (AWSAccount)AWSAccountPersistenceServiceImpl.this.ao.create(AWSAccount.class, params);
                return account;
            }
        });
        return this.createAWSAccountOrNull(aoEntity);
    }

    @Override
    public AWSAccountEntity save(AWSAccountEntity account, final boolean secretKeyChanged) {
        final AWSAccount originalEntity = account.getAWSAccountEntity();
        AWSAccount updatedEntity = (AWSAccount)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<AWSAccount>(){

            public AWSAccount doInTransaction() {
                if (secretKeyChanged) {
                    String encryptedSecretKey = AWSAccountPersistenceServiceImpl.this.encryptSecretKey(originalEntity.getAWSSecretKey());
                    originalEntity.setAWSSecretKey(encryptedSecretKey);
                }
                originalEntity.save();
                return AWSAccountPersistenceServiceImpl.this.getByIdOutsideTransaction(originalEntity.getId());
            }
        });
        return this.createAWSAccountOrNull(updatedEntity);
    }

    @Override
    public void delete(AWSAccountEntity account) {
        final AWSAccount originalEntity = account.getAWSAccountEntity();
        this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                AWSAccountPersistenceServiceImpl.this.ao.delete(new RawEntity[]{originalEntity});
                return null;
            }
        });
    }

    private String encryptSecretKey(String unencrypted) throws EncryptionFailureException, RuntimeException {
        byte[] secretKeyEncoded = this.encryptionHandler.encrypt(unencrypted);
        try {
            return new String(secretKeyEncoded, this.encryptionHandler.getCharset());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public AWSAccountEntity[] findAll() {
        AWSAccount[] aoEntities = (AWSAccount[])this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<AWSAccount[]>(){

            public AWSAccount[] doInTransaction() {
                String orderClause = "NAME ASC";
                Query query = Query.select().order(orderClause);
                return (AWSAccount[])AWSAccountPersistenceServiceImpl.this.ao.find(AWSAccount.class, query);
            }
        });
        return this.createAWSAccountArray(aoEntities);
    }

    @Override
    public AWSAccountEntity[] findByExactNameCI(final String name) {
        return (AWSAccountEntity[])this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<AWSAccountEntity[]>(){

            public AWSAccountEntity[] doInTransaction() {
                Predicate<AWSAccount> predicate = AWSAccountPredicates.nameEqualsIgnoreCase(name);
                return AWSAccountPersistenceServiceImpl.this.findByPredicate(predicate);
            }
        });
    }

    @Override
    public AWSAccountEntity[] findByPredicate(Predicate<AWSAccount> predicate) {
        Object[] allAccountsArray = (AWSAccount[])this.ao.find(AWSAccount.class);
        ImmutableSet allAccounts = ImmutableSet.copyOf((Object[])allAccountsArray);
        Comparator<AWSAccount> comparator = this.createAWSAccountNameComparator();
        List sortedFiltered = Ordering.from(comparator).sortedCopy(Iterables.filter((Iterable)allAccounts, predicate));
        return this.createAWSAccountArray(sortedFiltered);
    }

    private Comparator<AWSAccount> createAWSAccountNameComparator() {
        Comparator<AWSAccount> comparator = new Comparator<AWSAccount>(){

            @Override
            public int compare(AWSAccount account1, AWSAccount account2) {
                String name1 = account1.getName();
                String name2 = account2.getName();
                return name1.compareToIgnoreCase(name2);
            }
        };
        return comparator;
    }

    @Override
    public Map<String, Object> createEmptyPropertyMap() {
        HashMap<String, Object> emptyMap = new HashMap<String, Object>();
        emptyMap.put("ID", null);
        emptyMap.put("NAME", "");
        emptyMap.put("AWS_ACCESS_KEY_ID", "");
        emptyMap.put("AWS_SECRET_KEY", "");
        emptyMap.put("CLOUD_PROVIDER_KEY", null);
        emptyMap.put("V1_ID", null);
        return emptyMap;
    }

    @Override
    public Map<String, Object> toPropertyMap(AWSAccountEntity account) {
        HashMap<String, Object> emptyMap = new HashMap<String, Object>();
        emptyMap.put("ID", account.getId());
        emptyMap.put("NAME", account.getName());
        emptyMap.put("AWS_ACCESS_KEY_ID", account.getAWSAccessKeyId());
        emptyMap.put("AWS_SECRET_KEY", account.getAWSSecretKey());
        emptyMap.put("CLOUD_PROVIDER_KEY", account.getCloudProviderKey());
        emptyMap.put("V1_ID", account.getV1Id());
        return emptyMap;
    }

    private AWSAccountEntity createAWSAccountOrNull(AWSAccount aoEntity) {
        if (null != aoEntity) {
            return new AWSAccountEntityImpl(aoEntity);
        }
        return null;
    }

    private AWSAccountEntity[] createAWSAccountArray(AWSAccount[] aoEntities) {
        AWSAccountEntity[] results = new AWSAccountEntity[aoEntities.length];
        for (int i = 0; i < aoEntities.length; ++i) {
            results[i] = new AWSAccountEntityImpl(aoEntities[i]);
        }
        return results;
    }

    private AWSAccountEntity[] createAWSAccountArray(List<AWSAccount> sortedFiltered) {
        AWSAccountEntity[] results = new AWSAccountEntity[sortedFiltered.size()];
        for (int i = 0; i < sortedFiltered.size(); ++i) {
            results[i] = new AWSAccountEntityImpl(sortedFiltered.get(i));
        }
        return results;
    }
}

