/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws;

import com.amazonaws.auth.policy.Policy;
import com.amazonaws.services.securitytoken.model.PolicyDescriptorType;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class IAMPolicyValidator {
    public static final int MAXIMUM_POLICY_LENGHT = 2048;
    private static final String INVALID_POLICY_CHAR_PATTERN = "[^\\u0009\\u000A\\u000D\\u0020-\\u00FF]+";
    public static final int POLICY_ARNS_MAX = 10;
    private static final String POLICY_ARN_PATTERN = "arn:[a-zA-Z0-9-]*:iam:[a-zA-Z0-9-]*:[a-zA-Z0-9-]*:policy/.+";

    public static boolean validateJSON(String iamPolicy) {
        try {
            Policy policy = Policy.fromJson((String)iamPolicy);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public static List<String> validateCloudProviderArnFormat(String iamPolicy, String expectedARNKey) {
        ArrayList<String> errors = new ArrayList<String>();
        Pattern pattern = Pattern.compile("arn:([^:]+):");
        Matcher matcher = pattern.matcher(iamPolicy);
        while (matcher.find()) {
            if (matcher.group(1).equals(expectedARNKey)) continue;
            errors.add(matcher.group());
        }
        return errors;
    }

    public static boolean validatePolicyLength(String iamPolicy) {
        return 2048 >= iamPolicy.length();
    }

    public static List<String> validatePolicyChars(String iamPolicy) {
        ArrayList<String> errors = new ArrayList<String>();
        if (StringUtils.isBlank((String)iamPolicy)) {
            return errors;
        }
        Pattern pattern = Pattern.compile(INVALID_POLICY_CHAR_PATTERN);
        Matcher matcher = pattern.matcher(iamPolicy);
        while (matcher.find()) {
            errors.add(matcher.group());
        }
        return errors;
    }

    public static Collection<PolicyDescriptorType> parsePolicyArns(String policyArnsJson) {
        Collection parsedJson = null;
        if (StringUtils.isNotBlank((String)policyArnsJson)) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                parsedJson = (Collection)mapper.readValue(policyArnsJson, (TypeReference)new TypeReference<Collection<PolicyDescriptorType>>(){});
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        return parsedJson;
    }

    public static String serializePolicyArns(Collection<PolicyDescriptorType> policyArns) {
        ObjectMapper mapper = new ObjectMapper();
        String policyArnsJson = null;
        try {
            policyArnsJson = mapper.writeValueAsString(policyArns);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return policyArnsJson;
    }

    public static boolean validatePolicyArnsJsonFormat(String policyArnsJson) {
        try {
            Collection<PolicyDescriptorType> collection = IAMPolicyValidator.parsePolicyArns(policyArnsJson);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public static boolean validatePolicyArnsJsonNumber(String policyArnsJson) {
        try {
            Collection<PolicyDescriptorType> parsedPolicyArns = IAMPolicyValidator.parsePolicyArns(policyArnsJson);
            if (null != parsedPolicyArns && 10 < parsedPolicyArns.size()) {
                return false;
            }
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public static List<String> validatePolicyArnsFormat(String policyArnsJson) {
        ArrayList<String> errors;
        block4: {
            errors = new ArrayList<String>();
            try {
                Collection<PolicyDescriptorType> parsedPolicyArns = IAMPolicyValidator.parsePolicyArns(policyArnsJson);
                if (null != parsedPolicyArns && 0 < parsedPolicyArns.size()) {
                    for (PolicyDescriptorType policyDescriptorType : parsedPolicyArns) {
                        String arn = policyDescriptorType.getArn();
                        if (arn.matches(POLICY_ARN_PATTERN)) continue;
                        errors.add(arn);
                    }
                    break block4;
                }
                return errors;
            }
            catch (IllegalArgumentException e) {
                errors.add(e.getMessage());
            }
        }
        return errors;
    }
}

