/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.bamboo.ifaws;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import net.utoolity.atlassian.bamboo.ifaws.BaseTaskConfigurator;
import net.utoolity.atlassian.ifaws.aws.AWS;
import net.utoolity.atlassian.ifaws.aws.ECR;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ECRCredentialsVariablesTaskConfigurator
extends BaseTaskConfigurator {
    public static final String REGISTRY_ID = "registryId";
    private static final Set<String> FIELD_COLLECTION = ImmutableSet.builder().add((Object)"registryId").build();

    @Override
    protected Set<String> getFieldCollection() {
        return FIELD_COLLECTION;
    }

    @Override
    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
        this.validateRegion(params, errorCollection);
        this.validateRegistryId(params, errorCollection);
    }

    private void validateRegistryId(ActionParametersMap params, ErrorCollection errorCollection) {
        String registryId = params.getString(REGISTRY_ID);
        if (StringUtils.isBlank((String)registryId) || ECRCredentialsVariablesTaskConfigurator.isVariable(registryId)) {
            return;
        }
        if (!ECR.isValidECRRegistryId(registryId)) {
            errorCollection.addError(REGISTRY_ID, this.getI18nBean().getText("net.utoolity.atlassian.bamboo.ifaws.ecrcredentialsvariables.registryId.error"));
        }
    }

    @Override
    protected Map<String, String> getRegionMap() {
        return AWS.getRegionMap("api.ecr");
    }
}

