// TODO: Refactor for maintainability - remove code duplication and
// extract reusable functions to separate file (implies proper namespace addition), etc. 
AJS.toInit(function () {

    var contextPath = AJS.contextPath();
    var accountResourcePathRoot = contextPath + "/rest/identity-federation-for-aws/2.0/accounts";
    var accountResourcePath = accountResourcePathRoot + "/";

    function createDialogBase(submitLabel, submitCallback) {
        // Safeguard against a hidden 'rogue' dialog, which would result in duplicate ids,
        // and especially in duplicate forms, which would mess up the validation/persistence logic.
        // This can be triggered by e.g. 'closing' the dialog via the ESC key, which does not even
        // trigger the 'hide.dialog' event (which would have allowed us to ensure removal by binding to that)
        // To get around this mess, we just ensure a clean slate by removing such leftovers unconditionally:
        AJS.$("#aws-account-dialog").remove();
        // Create a new dialog
        var dialog = new AJS.Dialog({
            width: 400, 
            height: 400, 
            id: "aws-account-dialog", 
            closeOnOutsideClick: true
        });
        dialog.addSubmit(submitLabel, submitCallback);
        dialog.addCancel("Cancel", dialogCancel);
        return dialog;
    }

    function activateWaitIndicator(dialog) {
        // TODO: Using dummy page for now, but should probably switch
        // to 'standard' grey overlay with spinner
        AJS.$("#aws-account-dialog .button-panel-submit-button")
            .before("<span class=\"aui-icon aui-icon-wait\">" + AJS.I18n.getText("ifaws.accountCRUD.indicator.loading") + "</span>");
    }

    function deactivateWaitIndicator(dialog) {
        // TODO: Using dummy page for now, but should probably switch
        // to 'standard' grey overlay with spinner
        AJS.$("#aws-account-dialog .dialog-button-panel span.aui-icon-wait")
            .remove();
    }

    function htmlEscapeResponseText(responseText) {
        // KLUDGE: Prevent unescaped HTML usage in markup assembly, should be made obsolete by refactoring
        // to prevent any 'manual' markup assembly in the first place
        var tmpElement = AJS.$("<div/>").text(responseText);
        return tmpElement.html();
    }

    function textifyResponseText(responseText) {
        // KLUDGE: Quick fix for the rare case when we get an error response not created by us,
        // e.g. a tomcat error page markup - in that case, we reduce them to text only as an ugly,
        // but still somewhat useful format:
        var tmpElement = AJS.$("<div/>").html(responseText);
        return tmpElement.text();
    }

    function extractResponseError(data) {
        var error = {};
        error["title"] = data.statusText + " (" + data.status + ")";
        error["messages"] = [AJS.I18n.getText("ifaws.accountCRUD.responseError.default")];
        var responseText = data.responseText;
        if (responseText.length > 0) {
            try {
                details = jQuery.parseJSON(responseText);
                if (details.errorMessages) {
                    error["messages"] = details.errorMessages;
                }
                else {
                    AJS.log("The " + data.status + " response is not in the expected JSON format (missing property 'errorMessages').");
                    error["messages"] = [textifyResponseText(responseText)];
                }
            } catch (e) {
                // Not JSON, ignore.
                AJS.log("The " + data.status + " response is not in JSON format.");
                error["messages"] = [textifyResponseText(responseText)];
            }
        }

        return error;
    }

    var dialogAjaxErrorHandlerGeneric = function(data) {
        var dialog = this;
        var error = extractResponseError(data);
        var errorMessageCombined = AJS.I18n.getText("ifaws.accountCRUD.errorMessage.default");
        if (1 == error.messages.length) {
            errorMessageCombined = htmlEscapeResponseText(error.messages[0]);
        }
        else if (1 < error.messages.length) {
            errorMessageCombined = "<ul>";
            for (var i = 0; i < error.messages.length; i++) {
                errorMessageCombined += "<li>";
                errorMessageCombined += htmlEscapeResponseText(error.messages[i]);
                errorMessageCombined += "</li>";
            }
            errorMessageCombined += "</ul>";
        }
        AJS.messages.warning("#aws-account-dialog-error", {
            title: error.title,
            body: '<p>' + errorMessageCombined + '</p>',
            closeable: false
        });
        dialog.updateHeight();
        deactivateWaitIndicator(dialog);
    }

    function addAccountEditPanel(dialog, accountId) {
        // Clone and adjust template
        var form = AJS.$("#aws-account-dialog-template")
            .clone()
            .attr("id", "aws-account-dialog-form")
            .removeClass("hidden")
            .submit(function(e) {
                // Prevent standard submit ...
                e.preventDefault();
                //  ... and trigger dialog submit button instead
                AJS.$("#aws-account-dialog button.button-panel-submit-button").click();
            });
        // Add a hidden input field to allow 'submit on enter' kludge (submit is set to click the dialog submit button instead)
        AJS.$("<input/>").attr({
            type: "submit",
            id: "aws-account-dialog-form-submit-kludge",
            style: "visibility:hidden"
        }).appendTo(form);
        // Create a div container for error messages
        var errorContainer = AJS.$("<div/>")
            .attr("id", "aws-account-dialog-error")
        // Combine both, using temporary parent div to work around jQuery 1.9 behavior change for after() on disconnected nodes
        var dialogContent = AJS.$("<div/>")
            .append(errorContainer)
            .append(form)
            .children();
        // KLUDGE: Ensure a non duplicate id on the checkbox input field for label association (ends up as non clickable on later AUI versions otherwise)
        dialogContent.find("#ifaws-skip-validation-checkbox-container input")
          .attr("id", "ifaws-skip-validation");

        dialog.addPanel(AJS.I18n.getText("ifaws.accountCRUD.panelTitle.accountEdit"), dialogContent, "aws-account-dialog-panel");

        // Should we retrieve and add actual data?
        if (accountId) {
            activateWaitIndicator(dialog);
            // Call REST API
            var response = AJS.$.ajax({
              type: "GET",
              url: accountResourcePath + accountId,
              context: dialog,
              contentType: "application/json; charset=utf-8"
            });
            // Handle results (callbacks)
            response.done(dialogEditRetrieveDone);
            response.fail(dialogAjaxErrorHandlerGeneric);
        }
    }

    var dialogEditRetrieveDone = function(data) {
        var dialog = this;
        // Add retrieved data
        var awsAccount = data;
        AJS.$("#aws-account-dialog-form select#cloud-provider-key")
            .val(awsAccount.cloudProviderKey);
        AJS.$("#aws-account-dialog-form input.aws-account-id")
            .attr("value", awsAccount.id);
        AJS.$("#aws-account-dialog-form input.aws-account-name")
        .attr("value", awsAccount.name);
        AJS.$("#aws-account-dialog-form input.aws-access-key-id")
            .attr("value", awsAccount.awsAccessKeyId);
        AJS.$("#aws-account-dialog-form input.aws-secret-key")
            .attr("value", awsAccount.awsSecretKey);
        deactivateWaitIndicator(dialog);
    }

    var expectedFieldNames = ["name", "awsAccessKeyId", "awsSecretKey", "id", "cloudProviderKey"];

    var dialogGenericSubmit = function(dialog, page, requestType, requestUrlCallback, successCallback) {
        // Clear previous errors
        AJS.$("#aws-account-dialog-error").empty();
        AJS.$("#aws-account-dialog-form div.error")
            .remove();
        // Extract entered values, checking for empty fields on the fly
        var formValues = AJS.$("#aws-account-dialog-form").serializeArray();
        var accountData = {};
        accountData["cloudProviderKey"] = "aws";
        var hasErrors = false;
        for (var i = 0; i < formValues.length; i++) {
            if (AJS.$.inArray(formValues[i].name, expectedFieldNames) !== -1) {
                accountData[formValues[i].name] = formValues[i].value.trim();
                if (!formValues[i].value.trim()) {
                    hasErrors = true;
                    var errorDiv = AJS.$("<div/>")
                    .attr("class", "error")
                    .text(AJS.I18n.getText("ifaws.accountCRUD.validationError.missingField"));
                    AJS.$("#aws-account-dialog-form input[name=" + formValues[i].name + "]")
                    .after(errorDiv);
                }
            }
        }
        // Special handling for skip validation checkbox - we don not extract it into accountData,
        // as we do not want to pass it as that, rather we need to set it as a query param, if checkedd
        var skipValidation = AJS.$("#aws-account-dialog-form .ifaws-skip-validation-checkbox").prop("checked");
        if (hasErrors) {
            AJS.messages.warning("#aws-account-dialog-error", {
                title: AJS.I18n.getText("ifaws.accountCRUD.validationErrorMessage.title"),
                body: '<p>' + AJS.I18n.getText("ifaws.accountCRUD.validationErrorMessage.body") + '</p>',
                closeable: false
            });
            dialog.updateHeight();
        }
        else {
            // Set wait indicator
            activateWaitIndicator(dialog);
            // Call REST API
            var url = requestUrlCallback(accountData.id);
            // NOTE: Relying on URLs having no parameters besides skipValidation so far,
            // needs adjustment in case that changes
            if (skipValidation) {
                url += "?skipValidation=true";
            }
            var response = AJS.$.ajax({
                type: requestType,
                url: url,
                context: dialog,
                data: JSON.stringify(accountData),
                dataType: "json",
                contentType: "application/json; charset=utf-8"
            });
            // Handle results (callbacks)
            response.done(successCallback);
            response.fail(dialogAjaxErrorHandlerGeneric);
        }
    }

    var dialogEditSubmit = function(dialog, page) {
        dialogGenericSubmit(dialog, page, "PUT", dialogEditSubmitRequestUrlCallback, dialogEditDone)
    }

    var dialogEditSubmitRequestUrlCallback = function(accountId) {
        return accountResourcePath + accountId;
    }

    var dialogEditDone = function(data) {
        var dialog = this;
        // TODO/REVIEW: What sort order should we apply to the AWS Accounts,
        // and do we need to insert accordingly here? (inserting at end for now)
        var awsAccount = data;
        // Update existing option
        AJS.$("#aws-account-id option[value=" + awsAccount.id + "]")
            .text(awsAccount.name);
        // Make it selected
        AJS.$("#aws-account-id").val(awsAccount.id);
        // Trigger consequences
        AJS.$("#aws-account-id").change();
        dialog.remove();
    }

    function addAccountDeletePanel(dialog, accountId) {
        // We only need a message container for now
        var dialogContent = AJS.$("<div/>")
        .attr("id", "aws-account-dialog-error");

        dialog.addPanel(AJS.I18n.getText("ifaws.accountCRUD.panelTitle.accountDelete"), dialogContent, "aws-account-dialog-panel");

        if (accountId) {
            activateWaitIndicator(dialog);
            // Call REST API
            var response = AJS.$.ajax({
                type: "GET",
                url: accountResourcePath + accountId,
                context: dialog,
                contentType: "application/json; charset=utf-8"
            });
            // Handle results (callbacks)
            response.done(dialogDeleteRetrieveDone);
            response.fail(dialogAjaxErrorHandlerGeneric);
        }
    }

    var dialogDeleteRetrieveDone = function(data) {
        var dialog = this;
        var awsAccount = data;
        dialog.awsAccountData = awsAccount;

        // We do not allow cascading deletion of connectors for now
        if (!awsAccount.isDeletable) {
            AJS.messages.error("#aws-account-dialog-error", {
                title: AJS.I18n.getText("ifaws.accountCRUD.accountInUseErrorMessage.title"),
                body: '<p>' + AJS.I18n.getText("ifaws.accountCRUD.accountInUseErrorMessage.body") + '</p>',
                closeable: false
            });
            // Disable the delete button
            AJS.$("#aws-account-dialog .button-panel-submit-button").attr('disabled','disabled');
            // TODO: Maybe offer link to connector listing filtered by selected config id?
        }
        else {
            // Add confirmation message
            AJS.messages.warning("#aws-account-dialog-error", {
                title: AJS.I18n.getText("ifaws.accountCRUD.accountDeleteConfirmationMessage.title"),
                body: '<p>' + AJS.I18n.getText("ifaws.accountCRUD.accountDeleteConfirmationMessage.body") + ' <em>' + awsAccount.name + '</em>?</p>',
                closeable: false
            });
        }
        deactivateWaitIndicator(dialog);
        dialog.updateHeight();
    }

    var dialogDeleteSubmit = function(dialog, page) {
        var awsAccount = dialog.awsAccountData;
        // Set wait indicator
        activateWaitIndicator(dialog);
        // Call REST API
        var response = AJS.$.ajax({
          type: "DELETE",
          url: accountResourcePath + awsAccount.id,
          context: dialog,
          contentType: "application/json; charset=utf-8"
        });
        // Handle results (callbacks)
        response.done(dialogDeleteDone);
        response.fail(dialogAjaxErrorHandlerGeneric);
    }

    var dialogDeleteDone = function(data) {
        var dialog = this;
        // TODO/REVIEW: What sort order should we apply to the AWS Accounts,
        // and do we need to insert accordingly here? (inserting at end for now)
        var awsAccount = dialog.awsAccountData;
        // Remove existing option
        AJS.$("#aws-account-id option[value=" + awsAccount.id + "]")
            .remove();
        // Trigger consequences
        AJS.$("#aws-account-id").change();
        dialog.remove();
    }

    var dialogAddSubmit = function(dialog, page) {
        dialogGenericSubmit(dialog, page, "POST", dialogAddSubmitRequestUrlCallback, dialogAddDone)
    }

    var dialogAddSubmitRequestUrlCallback = function(accountId) {
        return accountResourcePathRoot;
    }

    var dialogAddDone = function(data) {
        var dialog = this;
        // TODO/REVIEW: What sort order should we apply to the AWS Accounts,
        // and do we need to insert accordingly here? (inserting at end for now)
        var awsAccount = data;
        // Add new option
        var option = AJS.$("<option/>")
            .attr("value", awsAccount.id)
            .text(awsAccount.name);
        AJS.$("#aws-account-id").append(option);
        // Make it selected
        AJS.$("#aws-account-id").val(awsAccount.id);
        // Trigger consequences
        AJS.$("#aws-account-id").change();
        dialog.remove();
    }

    var dialogCancel = function(dialog, page) {
        dialog.remove();
        return false;
    }

    var awsAccountAddDialog = function(e) {
        e.preventDefault();
        var dialog = createDialogBase(AJS.I18n.getText("ifaws.accountCRUD.submitLabel.accountAdd"), dialogAddSubmit);
        dialog.addHeader(AJS.I18n.getText("ifaws.accountCRUD.dialogHeader.accountAdd"));
        addAccountEditPanel(dialog, null);
        dialog.show();
        // Remove the hidden id field, as we do not need it on addition
        AJS.$("#aws-account-dialog-form input.aws-account-id").remove();
        dialog.updateHeight();
        AJS.$("#aws-account-dialog-form input.aws-account-name").focus();
    }

    var awsAccountEditDialog = function(e) {
        e.preventDefault();
        var selectedAccountId = AJS.$("#aws-account-id").val();
        var dialog = createDialogBase(AJS.I18n.getText("ifaws.accountCRUD.submitLabel.accountEdit"), dialogEditSubmit);
        dialog.addHeader(AJS.I18n.getText("ifaws.accountCRUD.dialogHeader.accountEdit"));
        addAccountEditPanel(dialog, selectedAccountId);
        dialog.show();
        dialog.updateHeight();
        AJS.$("#aws-account-dialog-form input.aws-account-name").focus();
    }

    var awsAccountDeleteDialog = function(e) {
        e.preventDefault();
        var selectedAccountId = AJS.$("#aws-account-id").val();
        var dialog = createDialogBase(AJS.I18n.getText("ifaws.accountCRUD.submitLabel.accountDelete"), dialogDeleteSubmit);
        dialog.addHeader(AJS.I18n.getText("ifaws.accountCRUD.dialogHeader.accountDelete"));
        addAccountDeletePanel(dialog, selectedAccountId);
        dialog.show();
        dialog.updateHeight();
        AJS.$("#aws-account-dialog button.button-panel-submit-button").focus();
    }

    var awsAccountIdChanged = function(e) {
        var selectedAccountId = AJS.$("#aws-account-id").val();
        var ec2PlaceholderAccountId = AJS.$('#aws-account-id').data('iamRoleForEc2AccountId');
        if (selectedAccountId == "-1" || selectedAccountId == ec2PlaceholderAccountId) {
            AJS.$(".aws-account-crud-togglelink").addClass("hidden");
            AJS.$(".aws-account-crud-togglelink-dummy").removeClass("hidden");
        }
        else {
            AJS.$(".aws-account-crud-togglelink").removeClass("hidden");
            AJS.$(".aws-account-crud-togglelink-dummy").addClass("hidden");
        }
    }

    AJS.$("#aws-account-id").change(awsAccountIdChanged);
    AJS.$("#aws-account-add").click(awsAccountAddDialog);
    AJS.$("#aws-account-edit").click(awsAccountEditDialog);
    AJS.$("#aws-account-delete").click(awsAccountDeleteDialog);
    awsAccountIdChanged();
});