/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.ui;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.utoolity.atlassian.dry.AUIMessage;
import net.utoolity.atlassian.dry.LicenseHelper;
import net.utoolity.atlassian.dry.PluginInfo;
import net.utoolity.atlassian.ifaws.FeatureFlag;
import net.utoolity.atlassian.ifaws.PluginConfiguration;
import net.utoolity.atlassian.ifaws.ao.AWSConnectorPersistenceService;
import net.utoolity.atlassian.ifaws.api.AWSConnectorType;
import net.utoolity.atlassian.ifaws.api.LicenseException;
import net.utoolity.atlassian.ifaws.api.TemporaryCredentialsDataStateDTO;
import net.utoolity.atlassian.ifaws.model.AWSConnectorEntity;
import net.utoolity.atlassian.ifaws.sso.AWSConsoleLoginUrlCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfigAWSConnectorOverviewServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(ConfigAWSConnectorOverviewServlet.class);
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_PAGE_LIMIT = 1000;
    private final WebSudoManager webSudoManager;
    private final LicenseHelper licenseHelper;
    private final TemplateRenderer renderer;
    private final I18nResolver i18n;
    private final AWSConnectorPersistenceService awsConnectorPersistenceService;
    private final AWSConsoleLoginUrlCreator awsConsoleLoginUrlCreator;
    private final PluginConfiguration pluginConfiguration;
    private final ObjectMapper objectMapper;

    @Autowired
    public ConfigAWSConnectorOverviewServlet(@ComponentImport WebSudoManager webSudoManager, LicenseHelper licenseHelper, @ComponentImport TemplateRenderer renderer, @ComponentImport I18nResolver i18n, AWSConnectorPersistenceService awsConnectorPersistenceService, PluginConfiguration pluginConfiguration, AWSConsoleLoginUrlCreator awsConsoleLoginUrlCreator) {
        this.webSudoManager = webSudoManager;
        this.licenseHelper = licenseHelper;
        this.renderer = renderer;
        this.i18n = i18n;
        this.awsConnectorPersistenceService = awsConnectorPersistenceService;
        this.pluginConfiguration = pluginConfiguration;
        this.awsConsoleLoginUrlCreator = awsConsoleLoginUrlCreator;
        this.objectMapper = new ObjectMapper();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            this.webSudoManager.willExecuteWebSudoRequest(request);
            String searchTerm = "";
            this.searchAndRender(searchTerm, request, response);
        }
        catch (WebSudoSessionException wes) {
            this.webSudoManager.enforceWebSudoProtection(request, response);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            this.webSudoManager.willExecuteWebSudoRequest(request);
            String searchTerm = request.getParameter("searchTerm");
            this.searchAndRender(searchTerm, request, response);
        }
        catch (WebSudoSessionException wes) {
            this.webSudoManager.enforceWebSudoProtection(request, response);
        }
    }

    private void searchAndRender(String searchTerm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ArrayList<AUIMessage> messages = new ArrayList<AUIMessage>();
        Boolean readOnly = false;
        try {
            this.licenseHelper.ensureValidLicense();
        }
        catch (LicenseException le) {
            readOnly = true;
            messages.add(this.licenseHelper.createAUIErrorMessage(le, AUIMessage.Type.WARNING, true));
        }
        Iterable<AWSConnectorEntity> foundConnectors = this.findConnectors(searchTerm);
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("searchTerm", searchTerm);
        context.put("awsConnectorList", foundConnectors);
        context.put("auditLinks", this.createAuditLinks(foundConnectors));
        context.put("credentialsDialogData", this.createCredentialsDialogData(foundConnectors));
        String pluginServletPathWithContext = request.getContextPath() + "/plugins/servlet/identity-federation-for-aws";
        context.put("pathToOverviewServlet", pluginServletPathWithContext + "/configuration/aws-connector");
        context.put("pathToEditServlet", pluginServletPathWithContext + "/configuration/aws-connector/");
        context.put("pathToFeatureServlet", pluginServletPathWithContext + "/configuration");
        context.put("messages", messages);
        context.put("readOnly", readOnly);
        context.put("pluginKey", PluginInfo.PLUGIN_KEY);
        context.put("showPartitionInfo", this.showPartitionInfo());
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("net/utoolity/atlassian/ifaws/templates/configAWSConnectorOverview.vm", context, (Writer)response.getWriter());
    }

    private boolean showPartitionInfo() {
        return this.pluginConfiguration.isFeatureEnabled(FeatureFlag.ENABLE_GOV_CLOUD) || this.pluginConfiguration.isFeatureEnabled(FeatureFlag.ENABLE_CHINA_PARTITION);
    }

    private Iterable<AWSConnectorEntity> findConnectors(String searchTerm) {
        return Arrays.asList(this.awsConnectorPersistenceService.findByFuzzySearch(searchTerm, 1000));
    }

    private Map<String, String> createAuditLinks(Iterable<AWSConnectorEntity> foundConnectors) {
        HashMap<String, String> auditLinks = new HashMap<String, String>();
        for (AWSConnectorEntity awsConnector : foundConnectors) {
            String auditTargetLink;
            String auditLink = auditTargetLink = this.createAuditTargetLink(awsConnector);
            if (!AWSConnectorType.SESSION_TOKEN.name().equals(awsConnector.getType())) {
                auditLink = this.awsConsoleLoginUrlCreator.createConsoleLoginUrl(awsConnector.getId(), auditTargetLink);
            }
            auditLinks.put(awsConnector.getId(), auditLink);
        }
        return auditLinks;
    }

    private String createAuditTargetLink(AWSConnectorEntity awsConnector) {
        String targetLinkTemplate = "%scloudtrail/home?#/events?AccessKeyId=%s";
        String managementConsoleUrl = awsConnector.getCloudProvider().getManagementConsoleURL();
        String accessKeyId = awsConnector.getAWSAccount().getAWSAccessKeyId();
        return String.format(targetLinkTemplate, managementConsoleUrl, accessKeyId);
    }

    private Map<String, String> createCredentialsDialogData(Iterable<AWSConnectorEntity> foundConnectors) {
        HashMap<String, String> dialogDataStates = new HashMap<String, String>();
        for (AWSConnectorEntity awsConnector : foundConnectors) {
            String dialogDataState = "";
            try {
                dialogDataState = this.createCredentialsDialogData(awsConnector);
            }
            catch (JsonProcessingException e) {
                this.log("Failed to create dialogDataState entry", e);
            }
            dialogDataStates.put(awsConnector.getId(), dialogDataState);
        }
        return dialogDataStates;
    }

    private String createCredentialsDialogData(AWSConnectorEntity awsConnector) throws JsonProcessingException {
        TemporaryCredentialsDataStateDTO dto = new TemporaryCredentialsDataStateDTO();
        dto.setId(awsConnector.getId());
        dto.setName(awsConnector.getName());
        String scopeDisplayName = "Default";
        if (null != awsConnector.getScope()) {
            scopeDisplayName = awsConnector.getScope().getDisplayName();
        }
        dto.setScope(scopeDisplayName);
        String typeDisplayName = this.i18n.getText("ifaws.AWSConnectorType.displayName." + awsConnector.getType());
        dto.setType(typeDisplayName);
        Integer durationSecondsMax = awsConnector.getDurationSecondsMax();
        if (null == durationSecondsMax) {
            try {
                durationSecondsMax = awsConnector.getTypeAsEnum().getDurationSecondsDefault();
            }
            catch (IllegalArgumentException e) {
                log.error("Could not evaluate connector type entry as enum value: " + awsConnector.getType());
                durationSecondsMax = 0;
            }
        }
        dto.setDurationSecondsMax(durationSecondsMax);
        dto.setAwsAccountId("not implemented");
        dto.setCredentialsProvider(awsConnector.getAWSAccount().getName());
        String serialized = this.objectMapper.writeValueAsString((Object)dto);
        byte[] encodedBytes = Base64.getEncoder().encode(serialized.getBytes(StandardCharsets.UTF_8));
        return new String(encodedBytes, StandardCharsets.UTF_8);
    }
}

