/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.ui;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.utoolity.atlassian.dry.AUIMessage;
import net.utoolity.atlassian.dry.EncryptionFailureException;
import net.utoolity.atlassian.dry.LicenseHelper;
import net.utoolity.atlassian.dry.PluginInfo;
import net.utoolity.atlassian.ifaws.api.LicenseException;
import net.utoolity.atlassian.ifaws.api.NotAuthorizedException;
import net.utoolity.atlassian.ifaws.sso.AWSConsoleLoginProxy;
import net.utoolity.atlassian.ifaws.sso.CreateSSORedirectUrlRequest;
import net.utoolity.atlassian.ifaws.sso.CreateSSORedirectUrlResponse;
import net.utoolity.atlassian.ifaws.sso.InvalidDestinationUrlException;
import net.utoolity.atlassian.ifaws.sso.MissingConnectorIdException;
import net.utoolity.atlassian.ifaws.sso.MultipleDestinationParametersException;
import net.utoolity.atlassian.ifaws.sso.NonAwsDestinationUrlException;
import net.utoolity.atlassian.ifaws.sso.UnknownConnectorIdException;
import org.apache.commons.lang.StringUtils;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.PolicyFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AWSConsoleLoginProxyServlet
extends HttpServlet {
    private static final String QUERY_PARAM_DESTINATION = "destination";
    private static final long serialVersionUID = 1L;
    private final LicenseHelper licenseHelper;
    private final TemplateRenderer renderer;
    private final I18nResolver i18n;
    private final AWSConsoleLoginProxy awsConsoleLoginProxy;

    @Autowired
    public AWSConsoleLoginProxyServlet(LicenseHelper licenseHelper, @ComponentImport TemplateRenderer renderer, @ComponentImport I18nResolver i18n, AWSConsoleLoginProxy awsConsoleLoginProxy) {
        this.licenseHelper = licenseHelper;
        this.renderer = renderer;
        this.i18n = i18n;
        this.awsConsoleLoginProxy = awsConsoleLoginProxy;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        AUIMessage message;
        ArrayList<AUIMessage> messages = new ArrayList<AUIMessage>();
        String nonSSOFallbackUrl = null;
        try {
            String idParam = this.extractIdParam(request);
            String destinationUrl = this.extractOptionalDestinationUrlParam(request);
            String issuerUrl = request.getRequestURL().toString();
            CreateSSORedirectUrlRequest ssoRedirectUrlRequest = new CreateSSORedirectUrlRequest().withConnectorId(idParam).withDestinationUrl(destinationUrl).withIssuerUrl(issuerUrl);
            CreateSSORedirectUrlResponse ssoRedirectUrlResponse = this.awsConsoleLoginProxy.createSSORedirectUrl(ssoRedirectUrlRequest);
            if (!ssoRedirectUrlResponse.hasError()) {
                response.sendRedirect(ssoRedirectUrlResponse.getSSOUrl());
                return;
            }
            if (null != ssoRedirectUrlResponse.getError()) {
                nonSSOFallbackUrl = ssoRedirectUrlResponse.getNonSSOFallbackUrl();
                throw ssoRedirectUrlResponse.getError();
            }
            String message2 = this.i18n.getText("ifaws.awsConsoleLoginProxy.undefinedErrorMessage");
            throw new RuntimeException(message2);
        }
        catch (LicenseException e) {
            messages.add(this.licenseHelper.createAUIErrorMessage(e, AUIMessage.Type.WARNING));
        }
        catch (NotAuthorizedException e) {
            message = new AUIMessage(AUIMessage.Type.WARNING, this.i18n.getText("ifaws.awsConsoleLoginProxy.federationError")).setMessage(e.getLocalizedMessage());
            messages.add(message);
        }
        catch (MissingConnectorIdException e) {
            message = new AUIMessage(AUIMessage.Type.ERROR, this.i18n.getText("ifaws.awsConsoleLoginProxy.requestError")).setMessage(this.i18n.getText("ifaws.awsConsoleLoginProxy.missingConnectorIdErrorMessage"));
            messages.add(message);
        }
        catch (UnknownConnectorIdException nae) {
            message = new AUIMessage(AUIMessage.Type.ERROR, this.i18n.getText("ifaws.awsConsoleLoginProxy.requestError")).setMessage(this.i18n.getText("ifaws.awsConsoleLoginProxy.unknownConnectorIdErrorMessage"));
            messages.add(message);
        }
        catch (MultipleDestinationParametersException e) {
            message = new AUIMessage(AUIMessage.Type.ERROR, this.i18n.getText("ifaws.awsConsoleLoginProxy.requestError")).setMessage(this.i18n.getText("ifaws.awsConsoleLoginProxy.multipleDestinationErrorMessage"));
            messages.add(message);
        }
        catch (NonAwsDestinationUrlException e) {
            message = new AUIMessage(AUIMessage.Type.ERROR, this.i18n.getText("ifaws.awsConsoleLoginProxy.requestError")).setMessage(this.i18n.getText("ifaws.awsConsoleLoginProxy.nonAwsDestinationErrorMessage"));
            messages.add(message);
        }
        catch (InvalidDestinationUrlException e) {
            message = new AUIMessage(AUIMessage.Type.ERROR, this.i18n.getText("ifaws.awsConsoleLoginProxy.requestError")).setMessage(this.i18n.getText("ifaws.awsConsoleLoginProxy.invalidDestinationErrorMessage"));
            messages.add(message);
        }
        catch (EncryptionFailureException e) {
            String errorMessageParagraphHtml = this.i18n.getText("ifaws.awsConsoleLoginProxy.encryptionFailureErrorMessage", new Serializable[]{e.getLocalizedMessage()});
            String kbLinkParagraphHtml = this.i18n.getText("ifaws.awsConsoleLoginProxy.encryptionFailureErrorMessageKBLink");
            AUIMessage message3 = new AUIMessage(AUIMessage.Type.ERROR, this.i18n.getText("ifaws.awsConsoleLoginProxy.decryptionError")).addMessageParagraphHtml(errorMessageParagraphHtml).addMessageParagraphHtml(kbLinkParagraphHtml);
            messages.add(message3);
        }
        catch (Throwable e) {
            message = new AUIMessage(AUIMessage.Type.ERROR, this.i18n.getText("ifaws.awsConsoleLoginProxy.federationError")).setMessage(e.getLocalizedMessage());
            messages.add(message);
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("messages", messages);
        String nonSSOLinkFragment = this.createNonSSOLinkFallback(nonSSOFallbackUrl);
        context.put("nonSSOLinkFragmentAsHtml", nonSSOLinkFragment);
        context.put("pluginKey", PluginInfo.PLUGIN_KEY);
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("net/utoolity/atlassian/ifaws/templates/awsConsoleLoginProxy.vm", context, (Writer)response.getWriter());
    }

    private String createNonSSOLinkFallback(String destinationUrl) {
        String link = this.i18n.getText("ifaws.awsConsoleLoginProxy.nonSSOLinkUnavailable");
        if (StringUtils.isNotBlank((String)destinationUrl)) {
            String untrustedLink = String.format("<a href=\"%s\" >%s</a>", destinationUrl, destinationUrl);
            link = this.sanitizeLink(untrustedLink);
        }
        return link;
    }

    private String sanitizeLink(String untrustedLink) {
        PolicyFactory policy = new HtmlPolicyBuilder().allowElements(new String[]{"a"}).allowUrlProtocols(new String[]{"https"}).allowAttributes(new String[]{"href"}).onElements(new String[]{"a"}).toFactory();
        return policy.sanitize(untrustedLink);
    }

    private String extractIdParam(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        if (null == pathInfo) {
            return null;
        }
        String[] pathInfoParts = pathInfo.split("/");
        if (pathInfoParts.length != 2) {
            return null;
        }
        return pathInfoParts[1];
    }

    private String extractOptionalDestinationUrlParam(HttpServletRequest request) {
        String[] destinations = request.getParameterValues(QUERY_PARAM_DESTINATION);
        if (null == destinations) {
            return null;
        }
        if (1 == destinations.length) {
            return destinations[0];
        }
        throw new MultipleDestinationParametersException();
    }
}

