/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.rest.v2;

import javax.ws.rs.core.Response;

public enum CustomStatus implements Response.StatusType
{
    UNPROCESSABLE_ENTITY(422, "Unprocessable Entity");

    private final int code;
    private final String reason;
    private Response.Status.Family family;

    private CustomStatus(int statusCode, String reasonPhrase) {
        this.code = statusCode;
        this.reason = reasonPhrase;
        switch (this.code / 100) {
            case 1: {
                this.family = Response.Status.Family.INFORMATIONAL;
                break;
            }
            case 2: {
                this.family = Response.Status.Family.SUCCESSFUL;
                break;
            }
            case 3: {
                this.family = Response.Status.Family.REDIRECTION;
                break;
            }
            case 4: {
                this.family = Response.Status.Family.CLIENT_ERROR;
                break;
            }
            case 5: {
                this.family = Response.Status.Family.SERVER_ERROR;
                break;
            }
            default: {
                this.family = Response.Status.Family.OTHER;
            }
        }
    }

    public Response.Status.Family getFamily() {
        return this.family;
    }

    public int getStatusCode() {
        return this.code;
    }

    public String getReasonPhrase() {
        return this.toString();
    }

    public String toString() {
        return this.reason;
    }

    public static CustomStatus fromStatusCode(int statusCode) {
        for (CustomStatus s : CustomStatus.values()) {
            if (s.code != statusCode) continue;
            return s;
        }
        return null;
    }
}

