/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.api;

import java.util.EnumSet;
import net.utoolity.atlassian.ifaws.api.StableId;

public enum AWSConnectorScope implements StableId
{
    SYSTEM(1, "System");

    private int stableId;
    private String displayName;

    private AWSConnectorScope(int stableId, String displayName) {
        this.stableId = stableId;
        this.displayName = displayName;
    }

    @Override
    public int getStableId() {
        return this.stableId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    private static AWSConnectorScope fromStableId(int stableId) {
        for (AWSConnectorScope scope : AWSConnectorScope.values()) {
            if (scope.getStableId() != stableId) continue;
            return scope;
        }
        return null;
    }

    public static int toBitmask(EnumSet<AWSConnectorScope> scopes) {
        int ret = 0;
        for (AWSConnectorScope scope : scopes) {
            ret |= 1 << scope.getStableId();
        }
        return ret;
    }

    public static EnumSet<AWSConnectorScope> fromBitmask(int bitmask) {
        EnumSet<AWSConnectorScope> scopes = EnumSet.noneOf(AWSConnectorScope.class);
        while (bitmask != 0) {
            int stableId = Integer.numberOfTrailingZeros(bitmask);
            bitmask ^= Integer.lowestOneBit(bitmask);
            scopes.add(AWSConnectorScope.fromStableId(stableId));
        }
        return scopes;
    }
}

