/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.utoolity.atlassian.ifaws.api.AWSConnectorDTO2;
import net.utoolity.atlassian.ifaws.api.AWSConnectorService2;
import net.utoolity.atlassian.ifaws.api.AWSConnectorType;

public class AWSConsoleLoginConnectorFilter {
    private final AWSConnectorService2 awsConnectorService2;

    public AWSConsoleLoginConnectorFilter(AWSConnectorService2 awsConnectorService2) {
        this.awsConnectorService2 = awsConnectorService2;
    }

    public List<AWSConnectorDTO2> getAvailableSSOConnectors() {
        List<AWSConnectorDTO2> allConnectors = this.awsConnectorService2.getConnectors();
        List<AWSConnectorDTO2> availableConnectors = this.filterNonSSOUsableConnectors(allConnectors);
        Collections.sort(availableConnectors, new AWSConnectorDTO2Comparator());
        return availableConnectors;
    }

    private List<AWSConnectorDTO2> filterNonSSOUsableConnectors(List<AWSConnectorDTO2> availableConnectors) {
        ArrayList<AWSConnectorDTO2> filteredConnectors = new ArrayList<AWSConnectorDTO2>();
        for (AWSConnectorDTO2 awsConnectorEntity : availableConnectors) {
            if (AWSConnectorType.SESSION_TOKEN.name().equals(awsConnectorEntity.getType())) continue;
            filteredConnectors.add(awsConnectorEntity);
        }
        return filteredConnectors;
    }

    private class AWSConnectorDTO2Comparator
    implements Comparator<AWSConnectorDTO2> {
        private AWSConnectorDTO2Comparator() {
        }

        @Override
        public int compare(AWSConnectorDTO2 c1, AWSConnectorDTO2 c2) {
            return Collator.getInstance().compare(c1.getName(), c2.getName());
        }
    }
}

