/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.aws;

import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.regions.Regions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.utoolity.atlassian.dry.StaticComponentAccessor;
import net.utoolity.atlassian.ifaws.FeatureFlag;
import net.utoolity.atlassian.ifaws.PluginConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AWS {
    private static final Logger log = LoggerFactory.getLogger(AWS.class);
    @VisibleForTesting
    public static final Map<String, String> MISSING_REGION_DESCRIPTIONS = new ImmutableMap.Builder().build();

    public static Map<String, String> getRegionMap() {
        return AWS.getRegionMap(null);
    }

    public static Map<String, String> getRegionMap(String endpointPrefix) {
        HashMap<String, String> regionMap = new HashMap<String, String>();
        List<Region> regions = AWS.getRegionsForService(endpointPrefix);
        for (Region region : regions) {
            String partition;
            String name = region.getName();
            String description = AWS.getRegionDescription(region);
            PluginConfiguration pluginConfiguration = StaticComponentAccessor.getPluginConfiguration();
            boolean isChinaPartitionEnabled = pluginConfiguration.isFeatureEnabled(FeatureFlag.ENABLE_CHINA_PARTITION);
            boolean isGovCloudPartitionEnabled = pluginConfiguration.isFeatureEnabled(FeatureFlag.ENABLE_GOV_CLOUD);
            switch (partition = region.getPartition()) {
                case "aws": {
                    regionMap.put(name, description);
                    break;
                }
                case "aws-cn": {
                    if (!isChinaPartitionEnabled) break;
                    regionMap.put(name, description);
                    break;
                }
                case "aws-us-gov": {
                    if (!isGovCloudPartitionEnabled) break;
                    regionMap.put(name, description);
                    break;
                }
                case "aws-iso": 
                case "aws-iso-b": {
                    break;
                }
            }
        }
        ImmutableSortedMap sortedMap = ImmutableSortedMap.copyOf(regionMap, (Comparator)Ordering.natural());
        return sortedMap;
    }

    private static String getRegionDescription(Region region) {
        try {
            Regions enumRegion = Regions.fromName((String)region.getName());
            return enumRegion.getDescription();
        }
        catch (IllegalArgumentException e) {
            if (MISSING_REGION_DESCRIPTIONS.containsKey(region.getName())) {
                String descriptionOverride = MISSING_REGION_DESCRIPTIONS.get(region.getName());
                log.warn("Using manually maintained description '{}' for region '{}'", (Object)descriptionOverride, (Object)region.getName());
                return descriptionOverride;
            }
            return region.getName();
        }
    }

    private static List<Region> getRegionsForService(String endpointPrefix) {
        List regions = null != endpointPrefix ? RegionUtils.getRegionsForService((String)endpointPrefix) : RegionUtils.getRegions();
        return regions;
    }
}

