/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.api;

import com.atlassian.upm.api.license.entity.LicenseError;

public class LicenseException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final LicenseErrorExtended licenseErrorExtended;

    public LicenseException(LicenseErrorExtended error) {
        super(error.name());
        this.licenseErrorExtended = error;
    }

    public LicenseException(LicenseError originalError) {
        this(LicenseErrorExtended.fromLicenseError(originalError));
    }

    public LicenseErrorExtended getLicenseErrorExtended() {
        return this.licenseErrorExtended;
    }

    public static enum LicenseErrorExtended {
        EXPIRED,
        TYPE_MISMATCH,
        USER_MISMATCH,
        VERSION_MISMATCH,
        EDITION_MISMATCH,
        ROLE_EXCEEDED,
        ROLE_UNDEFINED,
        MISSING,
        NO_STORAGE_PLUGIN,
        UNKNOWN;


        public static LicenseErrorExtended fromLicenseError(LicenseError originalError) {
            if (null == originalError) {
                return UNKNOWN;
            }
            try {
                LicenseErrorExtended match = LicenseErrorExtended.valueOf(originalError.name());
                return match;
            }
            catch (IllegalArgumentException iae) {
                return UNKNOWN;
            }
        }
    }
}

