/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.ao;

import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.utoolity.atlassian.ifaws.ao.AWSConnector;
import org.apache.commons.lang.StringUtils;

public final class AWSConnectorPredicates {
    private AWSConnectorPredicates() {
    }

    public static Predicate<AWSConnector> nameEquals(final String searchTerm) {
        return new Predicate<AWSConnector>(){

            public boolean apply(@Nullable AWSConnector input) {
                return StringUtils.equals((String)input.getName(), (String)searchTerm);
            }
        };
    }

    public static Predicate<AWSConnector> nameEqualsIgnoreCase(final String searchTerm) {
        return new Predicate<AWSConnector>(){

            public boolean apply(@Nullable AWSConnector input) {
                return StringUtils.equalsIgnoreCase((String)input.getName(), (String)searchTerm);
            }
        };
    }

    public static Predicate<AWSConnector> nameContainsIgnoreCase(final String searchTerm) {
        return new Predicate<AWSConnector>(){

            public boolean apply(@Nullable AWSConnector input) {
                return StringUtils.containsIgnoreCase((String)input.getName(), (String)searchTerm);
            }
        };
    }

    public static Predicate<AWSConnector> connectorContainsIgnoreCase(final String searchTerm) {
        return new Predicate<AWSConnector>(){

            public boolean apply(@Nullable AWSConnector input) {
                boolean nameMatch = StringUtils.containsIgnoreCase((String)input.getName(), (String)searchTerm);
                boolean accountNameMatch = StringUtils.containsIgnoreCase((String)input.getAWSAccount().getName(), (String)searchTerm);
                boolean accountKeyIdMatch = StringUtils.containsIgnoreCase((String)input.getAWSAccount().getAWSAccessKeyId(), (String)searchTerm);
                boolean idMatch = StringUtils.equalsIgnoreCase((String)input.getId(), (String)searchTerm);
                return nameMatch || idMatch || accountNameMatch || accountKeyIdMatch;
            }
        };
    }
}

