// NOTE: We go with simple namespace for starters
var UTOOLITY = UTOOLITY || {};

UTOOLITY.PolicyArnMultiSelect = function($element, contextPath) {
    var self = this;
    var delimiter = ",";
    var minimumInputLength = 0;
    this._selectedPolicyArns = [];
    var initialPolicyArnsCsv = $element.val();
    if (!!initialPolicyArnsCsv) {
        self._selectedPolicyArns = initialPolicyArnsCsv.split(delimiter);
    }

    this.removePolicyArn = function(policyArn) {
        var index = AJS.$.inArray(policyArn, self._selectedPolicyArns);
        if (index > -1) {
            self._selectedPolicyArns.splice( index, 1 );
        }
        self.updateValue();
    };
    
    this.addPolicyArn = function(policyArn) {
        var index = AJS.$.inArray(policyArn, self._selectedPolicyArns);
        if (index < 0) {
            self._selectedPolicyArns.push(policyArn);
        }
        self.updateValue();
    };
    
    this.updateValue = function() {
        $element.val(self._selectedPolicyArns.join(delimiter))
    };
    
    this.toggleRemoval= function(link) {
        var policyArn = link.dataset.policyarn;
        var enclosingRow = AJS.$(link).closest("tr");
        var iconSpan = AJS.$(link).find("span.aui-icon");
        if (enclosingRow.hasClass("ifaws-policy-arn-remove")) {
            // Request to undo remove, do so
            self.addPolicyArn(policyArn);
            enclosingRow.toggleClass("ifaws-policy-arn-remove");
            iconSpan.toggleClass("aui-iconfont-remove aui-iconfont-undo")
            link.title = link.dataset.policyarnremovelinktitle
        }
        else {
            // Request to remove, do so
            self.removePolicyArn(policyArn);
            enclosingRow.toggleClass("ifaws-policy-arn-remove");
            iconSpan.toggleClass("aui-iconfont-remove aui-iconfont-undo")
            link.title = link.dataset.policyarnundolinktitle
        }
    };
    
    $element.auiSelect2({
        placeholder: "Add Policy ARNs",
        minimumInputLength: minimumInputLength,
        multiple: true,
        // NOTE: We want to add lookup logic donw the road, but for now, we use straight 'tag' mode that only allows entering strings
/*        ajax: { // instead of writing the function to execute the request we use Select2's convenient helper
            url: contextPath + "/rest/identity-federation-for-aws/2.0/autocomplete/groups",
            dataType: 'json',
            quietMillis: 250,
            data: function (term, page) {
                return {
                    filter: term, // search term
                };
            },
            results: function (data, page) { // parse the results into the format expected by Select2.
                // since we are using custom formatting functions we do not need to alter the remote JSON data
                return { results: data };
            },
            cache: false // TODO/REVIEW: If set to false, it will force requested pages not to be cached by the browser. Default is false.
        },
*/
        tags: [],
        // KLUDGE: Prevent the "no matches found" string until we add actual lookup logic
        // NOTE: 'formatNoMatches' points to pre 4.0 select2 usage, will become 'language.noResults' then
        formatNoMatches : function () { return 'Enter a policy ARN'; },
        initSelection : function (element, callback) {
            var data = [];
            // NOTE: We do not want to show all selected arns in the widget, only new selections,
            // hence initializing to empty array (selected arns are tracked separately)
            callback(data);
        }
    }).on("change", this.updateSelectedPolicyArns.bind(this));
};

// TODO/REVIEW: This resulted from adaption of the stash example, but not sure if moving to explicit prototype function
// makes sense here, i.e. we will rarely use more than one instance per page, and this triggers the need for adjusting the
// this binding on each usage!?
UTOOLITY.PolicyArnMultiSelect.prototype.updateSelectedPolicyArns = function(changeEvent) {
    if (changeEvent.removed) {
      // NOTE: Depending on trigger, this can be a single object (e.g. on manual entry), or and array (e.g. on inline dialog based addition)
      if (Array.isArray(changeEvent.removed)) {
        changeEvent.removed.forEach(function(item){
          this.removePolicyArn(item.id);
        }, this);
      }
      else {
        // Assume single object
        this.removePolicyArn(changeEvent.removed.id);
      }
    }
    // NOTE: Same dual type logic as for remove above
    if (changeEvent.added) {
      if (Array.isArray(changeEvent.added)) {
        changeEvent.added.forEach(function(item){
          this.addPolicyArn(item.id);
        }, this);
      }
      else {
        // Assume single object
        this.addPolicyArn(changeEvent.added.id);
      }
    }
};

var UT = UTOOLITY;

AJS.toInit(function () {
    var contextPath = AJS.contextPath();
    var policyArnMultiSelect = new UT.PolicyArnMultiSelect(AJS.$("#policyArns"), contextPath);
    // TODO: Extract to widget function, decouple from innerHTML string
    AJS.$("#ifaws-selected-policy-arns-table a.ifaws-delete-button").click(function(e) {
        e.preventDefault();
        policyArnMultiSelect.toggleRemoval(this);
    });
});
