// NOTE: We go with simple namespace for starters
var UTOOLITY = UTOOLITY || {};
// TODO: Just to allow testing of proper inclusion, to be replaced with actual functionality later on
UTOOLITY.NamespaceTest = function() {alert("This is the Utoolity namespace")};

UTOOLITY.GroupMultiSelect = function($element, contextPath) {
    var self = this;
    var delimiter = ",";
    var minimumInputLength = 0;
    var groupCount = $element.data("groupcount");
    if (groupCount) {
        // REVIEW: What are decent cutoff points for the minimumInputLength (required chars to type before starting AJAX requests)
        if (groupCount > 100 && groupCount <= 100000) {
            minimumInputLength = 1;
        }
        else if (groupCount > 100000) {
            minimumInputLength = 2;
        }
    }
    this._selectedGroups = [];
    var initialGroupsCsv = $element.val();
    if (!!initialGroupsCsv) {
        self._selectedGroups = initialGroupsCsv.split(delimiter);
    }

    this.removeGroup = function(groupHashCode) {
        var index = AJS.$.inArray(groupHashCode, self._selectedGroups);
        if (index > -1) {
            self._selectedGroups.splice( index, 1 );
        }
        self.updateValue();
    };
    
    this.addGroup = function(groupHashCode) {
        var index = AJS.$.inArray(groupHashCode, self._selectedGroups);
        if (index < 0) {
            self._selectedGroups.push(groupHashCode);
        }
        self.updateValue();
    };
    
    this.updateValue = function() {
        $element.val(self._selectedGroups.join(delimiter))
    };
    
    this.toggleRemoval= function(link) {
        var groupHashCode = link.dataset.grouphashcode;
        var enclosingRow = AJS.$(link).closest("tr");
        var iconSpan = AJS.$(link).find("span.aui-icon");
        if (enclosingRow.hasClass("ifaws-group-remove")) {
            // Request to undo remove, do so
            self.addGroup(groupHashCode);
            enclosingRow.toggleClass("ifaws-group-remove");
            iconSpan.toggleClass("aui-iconfont-remove aui-iconfont-undo")
            link.title = link.dataset.groupremovelinktitle
        }
        else {
            // Request to remove, do so
            self.removeGroup(groupHashCode);
            enclosingRow.toggleClass("ifaws-group-remove");
            iconSpan.toggleClass("aui-iconfont-remove aui-iconfont-undo")
            link.title = link.dataset.groupundolinktitle
        }
    };
    
    $element.auiSelect2({
        placeholder: "Add Groups",
        minimumInputLength: minimumInputLength,
        multiple: true,
        ajax: { // instead of writing the function to execute the request we use Select2's convenient helper
            url: contextPath + "/rest/identity-federation-for-aws/2.0/autocomplete/groups",
            dataType: 'json',
            quietMillis: 250,
            data: function (term, page) {
                return {
                    filter: term, // search term
                };
            },
            results: function (data, page) { // parse the results into the format expected by Select2.
                // since we are using custom formatting functions we do not need to alter the remote JSON data
                return { results: data };
            },
            cache: false // TODO/REVIEW: If set to false, it will force requested pages not to be cached by the browser. Default is false.
        },
        initSelection : function (element, callback) {
            var data = [];
            // NOTE: We do not want to show all selected groups in the widget, only new selections,
            // hence initializing to empty array (selected groups are tracked separately)
            callback(data);
        }
    }).on("change", this.updateSelectedGroups.bind(this));
};

// TODO/REVIEW: This resulted from adaption of the stash example, but not sure if moving to explicit prototype function
// makes sense here, i.e. we will rarely use more than one instance per page, and this triggers the need for adjusting the
// this binding on each usage!?
UTOOLITY.GroupMultiSelect.prototype.updateSelectedGroups = function(changeEvent) {
    if (changeEvent.removed) {
        this.removeGroup(changeEvent.removed.id);
    }
    if (changeEvent.added) {
        this.addGroup(changeEvent.added.id);
    }
};

var UT = UTOOLITY;

AJS.toInit(function () {
    var contextPath = AJS.contextPath();
    var groupMultiSelect = new UT.GroupMultiSelect(AJS.$("#groups"), contextPath);
    // TODO: Extract to widget function, decouple from innerHTML string
    AJS.$("#ifaws-selected-groups-table a.ifaws-delete-button").click(function(e) {
        e.preventDefault();
        groupMultiSelect.toggleRemoval(this);
    });
});
